using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.IO;
using System.Xml;
using System.Xml.Serialization;


namespace pmsDataGridView
{
    public class ActionRecord
    {
        public enum ActionColumnType { DATE, ACTION, COMMENT }
               
        #region Constructor and Destructor
        
        public ActionRecord() { }      
       
        public ActionRecord(DateTime date, string action, string comment)
        {
            this.Date = date;
            this.Action = action;
            this.Comment = comment;
        }

        ~ActionRecord() { }

        #endregion

        //Methods       
        public void fill_to_row_i(System.Windows.Forms.DataGridView ActionLogGrid, int i)
        {//This function fills action on a row, either replace an old action or to add a new action. 
            //need to add a new row before calling this function if adding a new action
            //when it's filling a action to list, maybe due to search results, doesn't consider to change of value 
            //for the cell, hence shouldn't trigger ActionLogGrid_CellValueChanged
            Filling_a_action_to_list = true;
            //if not enought rows, add more
            if (i == ActionLogGrid.Rows.Count)
            {
                ActionLogGrid.Rows.Add();
            }
            //productlist.Bearings[last_action_index].Index = last_action_index; //reset all the indices
            ActionLogGrid.Rows[i].Cells[(int)ActionColumnType.DATE].Value = this.Date.ToLongDateString();
            ActionLogGrid.Rows[i].Cells[(int)ActionColumnType.ACTION].Value = this.Action;
            ActionLogGrid.Rows[i].Cells[(int)ActionColumnType.COMMENT].Value = this.Comment; 
            Filling_a_action_to_list = false;  
        }

        //Variables      
        public DateTime Date;
        public string Action;
        public string Comment;
        public bool Filling_a_action_to_list = false;
        public int Index = -1;
    }

    public class ActionLogList
    {
        #region Constructor and Distructor
        public ActionLogList()
        {
            ActionLoglist = new ArrayList();
        }
        ~ActionLogList() { }
        #endregion

        #region Methods

        public void add(ActionRecord s)
        {
            ActionLoglist.Add(s);
            //s.Index = Count - 1;
        }

        public ActionRecord get_ActionLog(int location) //0 based index  
        {
            if (location < ActionLoglist.Count)
            {
                return (ActionRecord)ActionLoglist[location];
            }
            else return null;
        }

        public void fill_grid(System.Windows.Forms.DataGridView ActionLogGrid, CustomerList customerlist)
        {
            for (int i = 0; i < Count; i++)
            {
                ActionRecord s = this[i];
                //ActionLogGrid.Rows.Add();
                s.fill_to_row_i(ActionLogGrid, i);                
            }
        }

        public int Count
        {
            get { return ActionLoglist.Count; }
        }

        public void remove(int location) //0 based index  
        {
            if (location < ActionLoglist.Count)
            {
                ActionLoglist.RemoveAt(location);
                
                for (int i = location; i < Count; i++) //decrement indices of actionrecords after 'location' 
                {
                    this[i].Index--;
                }
                 
            }
            else return;
        }

        public void copy(ActionLogList sample)
        {
            this.ActionLoglist = sample.ActionLoglist;
        }

        //Indexer
        public ActionRecord this[int location]
        {
            get { return (ActionRecord)ActionLoglist[location]; }
            set { ActionLoglist[location] = value; }
        }

        [XmlIgnore]
        public string data_path
        {
            get { return FilePath; }
            set { FilePath = value; }
        }

        #endregion

        #region XML read and write methods

        [XmlElement("Action")]
        //this is a property, when use: item.items[0], returns an item
        public ActionRecord[] ActionRecords
        {
            get
            {
                ActionRecord[] actionrecords = new ActionRecord[ActionLoglist.Count];
                ActionLoglist.CopyTo(actionrecords);
                return actionrecords;
            }

            set
            {
                if (value == null) return;
                ActionRecord[] actionrecords = (ActionRecord[])value;
                ActionLoglist.Clear();
                foreach (ActionRecord b in actionrecords)
                {
                    ActionLoglist.Add(b);
                }
            }
        } 

        public virtual void save()
        {

            // Serialization
            XmlSerializer ser = new XmlSerializer(typeof(ActionLogList));
            TextWriter xml_write = new StreamWriter(FilePath);

            ser.Serialize(xml_write, this);
            xml_write.Close();
        }

        public virtual void load()
        {
            ActionLogList temp = new ActionLogList();
            // Deserialization

            XmlSerializer ser = new XmlSerializer(typeof(ActionLogList));

            if (FilePath != null && File.Exists(FilePath))
            {
                TextReader xml_read = new StreamReader(FilePath);

                temp = (ActionLogList)ser.Deserialize(xml_read);

                copy(temp);
                xml_read.Close();
            }
            else //dont find the xml file, so creat an empty sell list anyway
            {
                copy(temp);
            }
        }

        #endregion

        #region Private variables

        private ArrayList ActionLoglist;
        private string FilePath = @"../../ProgramData/ActionData.xml";

        #endregion
 
  

    }
}
