﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace pmsDataGridView
{
    public partial class AddTransactionForm : Form
    {
        public AddTransactionForm()
        {
            InitializeComponent();
            dateTimePicker1.Value = DateTime.Now;
            TranscTypeCombo.SelectedIndex = 0; //use payee as default
            AmountTextBox.Text = "0"; 
        }
        public AddTransactionForm(AccountLogList transactionlist)
            : this()
        {
            this.transactionlist = transactionlist;           
            //ComboBox.ObjectCollection objc = new ComboBox.ObjectCollection(CatagoryCombo);
            for (int i = 0; i < transactionlist.Categorylist.Count; i++)
            {
                CatagoryCombo.Items.Add(transactionlist.Categorylist[i]);
            }
        }

        private void AddCatagoryButton_Click(object sender, EventArgs e)
        {
            if (CatagoryCombo.Text != null)
            {
                string new_catagory = CatagoryCombo.Text;
                transactionlist.Categorylist.Add(new_catagory);
                CatagoryCombo.Items.Add(new_catagory);
            }

        }        

        private void RemoveButton_Click(object sender, EventArgs e)
        {
            if (CatagoryCombo.Text != null)
            {
                string selected_catagory = CatagoryCombo.Text;
                transactionlist.Categorylist.Remove(selected_catagory);
                CatagoryCombo.Items.Remove(selected_catagory);
            }
        }
        public AccountLogList transactionlist;
        public bool OKpressed = false;

        private void OkButton_Click(object sender, EventArgs e)
        {
            if (AmountTextBox.Text != null)//make sure the amount text box is not empty
            {
                OKpressed = true;
                string payee = PayeeTextBox.Text;
                int cindex = CatagoryCombo.SelectedIndex;
                double amount = Convert.ToDouble(AmountTextBox.Text);
                string note = NoteTextBox.Text;
                bool moneyin;
                if (TranscTypeCombo.SelectedIndex == 0) //0 is pay, 1 is income
                {
                    moneyin = false;
                }
                else
                {
                    moneyin = true;
                }
                AccountRecord new_transc = new AccountRecord(payee, cindex, amount, moneyin, note);
                transactionlist.add(new_transc);
            }
            Close();
        }

        private void CancelButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void CatagoryCombo_SelectedIndexChanged(object sender, EventArgs e)
        {
            //auto complete for the selected catagory            
            string selected_cat = CatagoryCombo.SelectedItem.ToString();
            if (selected_cat != null)
            {
                switch (selected_cat)
                {
                    case ("Promotion"):
                        PayeeTextBox.Text = "Trade Me";
                        AmountTextBox.Text = "20.00";
                        break;
                    case ("Local shipping"):
                        PayeeTextBox.Text = "NZpost";
                        break;
                    case("Inter. shipping"):
                        PayeeTextBox.Text = "Chinapost";
                        break;
                    case("Bearing cost"):
                        PayeeTextBox.Text = "Bearing suplier";
                        break;
                }
            }
        }
    }
}
