﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace pmsDataGridView
{
    public partial class BuyinForm : Form
    {

        public MainForm mainform;
        public BuyinRecord buyinrecord = new BuyinRecord();
        public ProductList productlist = new ProductList(); //read only
        public ProductList orderlist = new ProductList();
        public bool OkPressed = false;
        public int selected_row_index;
        public int selected_buyin_index;

        public BuyinForm()
        {
            InitializeComponent();
        }

        public BuyinForm(MainForm mf)
            : this() //call the constructor without argument first
        {
            this.mainform = mf;
        }

        public BuyinForm(BuyinRecord br, int selected_row_index, ProductList productlist)
            : this()
        {
            this.buyinrecord = br;
            this.productlist = productlist;
            this.selected_row_index = selected_row_index;
            this.selected_buyin_index = br.Index;
            br.ProductOrder.refresh_grid(BuyinGrid);
        }
        private void toolStripButtonAdd_Click(object sender, EventArgs e)
        {
            //if there is any alreay order, copy it through to the list
            SelectFromProductlistForm AddForm = new SelectFromProductlistForm(productlist,orderlist);                      
            AddForm.Show();
            AddForm.FormClosed += new FormClosedEventHandler(SelectFromProductlistForm_FormClosed);
        }
        private void SelectFromProductlistForm_FormClosed(object sender, FormClosedEventArgs e)
        {          
            SelectFromProductlistForm productlistform = (SelectFromProductlistForm)sender;
            if (productlistform.OkPressed == true)
            {
                orderlist = productlistform.orderlist;
                orderlist.refresh_grid(BuyinGrid);
            }
        }

        private void toolStripButtonOK_Click(object sender, EventArgs e)
        {
            buyinrecord.ProductOrder = orderlist;
            OkPressed = true;
            Close();
        } 


    }
}
