using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.IO;
using System.Xml;
using System.Xml.Serialization;


namespace pmsDataGridView
{
    public class BuyinRecord
    {
        public enum GridColumnType { ID, LODGEDATE, ARRIVEDDATE, PAYABLE, ARRIVEDNZ, PAID, INDEX }
        #region Constructor and Destructor        
        public BuyinRecord()
        {
            this.lodgedDate = DateTime.Now; //stamp the current time when the buyin is lodged                             

            //Work out the ID based on the date down to the seconds
            this.ID = lodgedDate.Year + lodgedDate.Month.ToString("00") + lodgedDate.Day.ToString("00") + lodgedDate.Hour.ToString("00")
                + lodgedDate.Minute.ToString("00") + lodgedDate.Second.ToString("00");
        }
        public BuyinRecord(ProductList bearingorder, string comment)
            : this()
        {
            this.Comment = comment;
        }

        ~BuyinRecord() { }

        #endregion

        //Methods
        public void updatePayable()
        {
            //work out total payable
            double total_payable = 0.0;
            //sums up the cost of the ordered bearings
            for (int i = 0; i < ProductOrder.Count; i++)
            {
                total_payable += ProductOrder.Bearings[i].Price * ProductOrder.Bearings[i].quantity;
            }
            this.totalPayable = total_payable;
        }

        public void fill_to_row_i(System.Windows.Forms.DataGridView BuyinGrid, int i)
        {
            if (i == BuyinGrid.Rows.Count)
            {
                BuyinGrid.Rows.Add();
            }
            DateTime initialized_date = new DateTime();
            BuyinGrid.Rows[i].Cells[(int)GridColumnType.ID].Value = this.ID;
            BuyinGrid.Rows[i].Cells[(int)GridColumnType.LODGEDATE].Value = this.lodgedDate.ToLongDateString();
            BuyinGrid.Rows[i].Cells[(int)GridColumnType.ARRIVEDDATE].Value = (this.arrivedDate == initialized_date) ? null : this.arrivedDate.ToLongDateString();
            BuyinGrid.Rows[i].Cells[(int)GridColumnType.PAYABLE].Value = this.totalPayable.ToString("0.00");
            BuyinGrid.Rows[i].Cells[(int)GridColumnType.ARRIVEDNZ].Value = this.arrivedNZ;
            BuyinGrid.Rows[i].Cells[(int)GridColumnType.PAID].Value = this.paid;
            BuyinGrid.Rows[i].Cells[(int)GridColumnType.INDEX].Value = this.Index;
        }
        public void fill_to_last_row(System.Windows.Forms.DataGridView BuyinGrid)
        {
            int i = BuyinGrid.Rows.Count - 1;
            fill_to_row_i(BuyinGrid, i);
        }

        #region Properties
        
        //Variables      
        public string trackingNumber = null;
        public DateTime lodgedDate;
        public DateTime arrivedDate;        
        public DateTime paidDate;
        public DateTime ExRateDate;
        public double nzd2cnyExRate = 0;
        public bool paid = false;
        public bool arrivedNZ = false;
        public ProductList ProductOrder = new ProductList();
        
        public string ID = "";
        public int Index = -1;
        
       
        public double totalPayable = 0.0;
        public string Comment;        

        #endregion
    }

    public class BuyinList
    {
        #region Constructor and Distructor
        public BuyinList()
        {
            Buyinlist = new ArrayList();
        }
        ~BuyinList() { }
        #endregion

        #region Methods

        public void add(BuyinRecord s)
        {
            Buyinlist.Add(s);
            //s.Index = Count - 1;
        }

        public BuyinRecord get_SaleLog(int location) //0 based index  
        {
            if (location < Buyinlist.Count)
            {
                return (BuyinRecord)Buyinlist[location];
            }
            else return null;
        }

        public int Count
        {
            get { return Buyinlist.Count; }
        }

        public void remove(int location) //0 based index  
        {
            if (location < Buyinlist.Count)
            {
                Buyinlist.RemoveAt(location);
                
                for (int i = location; i < Count; i++) //decrement indices of salerecords after 'location' 
                {
                    this[i].Index--;
                }
                 
            }
            else return;
        }

        public void copy(BuyinList sample)
        {
            this.Buyinlist = sample.Buyinlist;
        }

        //Indexer
        public BuyinRecord this[int location]
        {
            get { return (BuyinRecord)Buyinlist[location]; }
            set { Buyinlist[location] = value; }
        }

        [XmlIgnore]
        public string data_path
        {
            get { return FilePath; }
            set { FilePath = value; }
        }

        #endregion

        #region XML read and write methods

        [XmlElement("Sale")]
        //this is a property, when use: item.items[0], returns an item
        public SaleRecord[] SaleRecords
        {
            get
            {
                SaleRecord[] salerecords = new SaleRecord[Buyinlist.Count];
                Buyinlist.CopyTo(salerecords);
                return salerecords;
            }

            set
            {
                if (value == null) return;
                SaleRecord[] salerecords = (SaleRecord[])value;
                Buyinlist.Clear();
                foreach (SaleRecord b in salerecords)
                {
                    Buyinlist.Add(b);
                }
            }
        } 

        public virtual void save()
        {

            // Serialization
            XmlSerializer ser = new XmlSerializer(typeof(BuyinList));
            TextWriter xml_write = new StreamWriter(FilePath);

            ser.Serialize(xml_write, this);
            xml_write.Close();
        }

        public virtual void load()
        {
            BuyinList temp = new BuyinList();
            // Deserialization

            XmlSerializer ser = new XmlSerializer(typeof(BuyinList));

            if (FilePath != null && File.Exists(FilePath))
            {
                TextReader xml_read = new StreamReader(FilePath);

                temp = (BuyinList)ser.Deserialize(xml_read);

                copy(temp);
                xml_read.Close();
            }
            else //dont find the xml file, so creat an empty sell list anyway
            {
                copy(temp);
            }
        }

        #endregion

        #region Private variables

        private ArrayList Buyinlist;
        private string FilePath = @"../../ProgramData/BuyinData.xml";

        #endregion
 
  

    }
}
