using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.IO;
using System.Xml;
using System.Xml.Serialization;


namespace pmsDataGridView
{
    public class Customer
    {
        public enum CustomerColumnType { NAME, USERNAME, EMAIL, FREQUENCY, ADDRESS, COUNTRY, INDEX }        
        #region Constructor and Destructor
        
        public Customer() { }

        //public Customer(string name, string username, string email, string line1, string line2, string line3, string country, string comment) 
        //{
        //    this.Comment = comment;
        //    this.Name = name;
        //    this.UserName = username;
        //    this.Email = email;            
        //    this.AddressLine1 = line1;
        //    this.AddressLine2 = line2;
        //    this.AddressLine3 = line3;
        //    this.Country = country;
        //}

        public Customer(string name, string username, string email, string address, string country, string comment)
        {
            this.Comment = comment;
            this.Name = name;
            this.UserName = username;
            this.Email = email;
            this.Address = address;
            this.Country = country;
        }
        ~Customer() { }

        #endregion

        //Methods
        
        //Variables        
        public string Name;
        public string UserName; //trademe account name
        public string Email;               
        //public string AddressLine1;
        //public string AddressLine2;
        //public string AddressLine3;
        public string Address;
        public string Country = "New Zealand";
        public string Comment;
        public int Frequency = 1;
        public int Index = -1;
        public void fill_to_row_i(System.Windows.Forms.DataGridView CustomerGrid, int i)
        {
            //This function fills a customer on a row, either replace an old sale or to add a new sale. 
            //need to add a new row before calling this function if adding a new sale
            //if not enought rows, add more
            if (i == CustomerGrid.Rows.Count)
            {
                CustomerGrid.Rows.Add();
            }
            CustomerGrid.Rows[i].Cells[(int)CustomerColumnType.NAME].Value = this.Name;
            CustomerGrid.Rows[i].Cells[(int)CustomerColumnType.USERNAME].Value = this.UserName;
            CustomerGrid.Rows[i].Cells[(int)CustomerColumnType.EMAIL].Value = this.Email;
            CustomerGrid.Rows[i].Cells[(int)CustomerColumnType.ADDRESS].Value = this.Address;
            CustomerGrid.Rows[i].Cells[(int)CustomerColumnType.FREQUENCY].Value = this.Frequency;
            CustomerGrid.Rows[i].Cells[(int)CustomerColumnType.COUNTRY].Value = this.Country;
            CustomerGrid.Rows[i].Cells[(int)CustomerColumnType.INDEX].Value = this.Index;

        }
    }

    public class CustomerList
    {
        #region Constructor and Distructor
        public CustomerList()
        {
            customerList = new ArrayList();
        }
        ~CustomerList() { }
        #endregion

        #region Methods

        public void add(Customer s)
        {          
            customerList.Add(s);
            //s.Index = Count - 1;
        }

        public Customer get_SaleLog(int location) //0 based index  
        {
            if (location < customerList.Count)
            {
                return (Customer)customerList[location];
            }
            else return null;
        }

        public void fill_grid(System.Windows.Forms.DataGridView CustomerGrid)
        {
            for (int i = 0; i < Count; i++)
            {
                Customer c = this[i];
                //CustomerGrid.Rows.Add();
                c.fill_to_row_i(CustomerGrid, i);                
            }
        }

        public int Count
        {
            get { return customerList.Count; }
        }

        public void remove(int location) //0 based index  
        {
            if (location < customerList.Count)
            {
                customerList.RemoveAt(location);
                
                for (int i = location; i < Count; i++) //decrement indices of salerecords after 'location' 
                {
                    this[i].Index--;
                }
                 
            }
            else return;
        }

        public void copy(CustomerList sample)
        {
            this.customerList = sample.customerList;
        }

        //Indexer
        public Customer this[int location]
        {
            get { return (Customer)customerList[location]; }
            set { customerList[location] = value; }
        }

        [XmlIgnore]
        public string data_path
        {
            get { return FilePath; }
            set { FilePath = value; }
        }

        #endregion

        #region XML read and write methods

        [XmlElement("Customer")]
        //this is a property, when use: item.items[0], returns an item
        public Customer[] Customers
        {
            get
            {
                Customer[] customers = new Customer[customerList.Count];
                customerList.CopyTo(customers);
                return customers;
            }

            set
            {
                if (value == null) return;
                Customer[] customers = (Customer[])value;
                customerList.Clear();
                foreach (Customer b in customers)
                {
                    customerList.Add(b);
                }
            }
        } 

        public virtual void save()
        {

            // Serialization
            XmlSerializer ser = new XmlSerializer(typeof(CustomerList));
            TextWriter xml_write = new StreamWriter(FilePath);

            ser.Serialize(xml_write, this);
            xml_write.Close();
        }

        public virtual void load()
        {
            CustomerList temp = new CustomerList();
            // Deserialization

            XmlSerializer ser = new XmlSerializer(typeof(CustomerList));

            if (FilePath != null && File.Exists(FilePath))
            {
                TextReader xml_read = new StreamReader(FilePath);

                temp = (CustomerList)ser.Deserialize(xml_read);

                copy(temp);
                xml_read.Close();
            }
            else //dont find the xml file, so creat an empty customer list anyway
            {
                copy(temp);
            }
        }

        #endregion

        #region Private variables

        private ArrayList customerList;
        private string FilePath = @"../../ProgramData/CustomerData.xml";

        #endregion
 
  

    }
}
