﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace pmsDataGridView
{
    public partial class CustomerEditForm : Form
    {
        public CustomerEditForm()
        {
            InitializeComponent();
        }

        public CustomerEditForm(string email)
            : this()
        {
            //prefill
            CountryTextBox.Text = "New Zealand";  
            //this constructor is called when the email is known (or entered)
            EmailTextBox.Text = email;
        }

        public CustomerEditForm(Customer c, int selected_row_index)
            : this()
        {
            // the selected_row_index argument mainly to keep track of the selected row becuase it may differ from the customer index after 
            // the customer grid is resorted
            EditMode = true;
            //fill up all the text boxes
            NameTextBox.Text = c.Name;
            EmailTextBox.Text = c.Email;
            UserNameTextBox.Text = c.UserName;
            AddressTextBox.Text = c.Address;
            CountryTextBox.Text = c.Country;
            CustomerCommentTextBox.Text = c.Comment;
            
            //main purpose is to copy the old index to the new one
            this.customer = c;
            this.selected_row_index = selected_row_index;
        }

        private void Cancel_Click(object sender, EventArgs e)
        {
            Hide();
        }

        private void OK_Click(object sender, EventArgs e)
        {
            OKpressed = true;
            if (EditMode)
            {
                //update the submited customer's detail
                customer.Name = NameTextBox.Text;
                customer.UserName = UserNameTextBox.Text;
                customer.Email = EmailTextBox.Text;
                customer.Address = AddressTextBox.Text;
                customer.Country = CountryTextBox.Text;
                customer.Comment = CustomerCommentTextBox.Text;
            }
            else 
            {
                customer = new Customer(NameTextBox.Text, UserNameTextBox.Text, EmailTextBox.Text, AddressTextBox.Text, CountryTextBox.Text, CustomerCommentTextBox.Text);
            }
            Close();
        }

        public bool OKpressed = false;
        public Customer customer;
        public bool EditMode = false; //as oppose to add mode
        public int selected_row_index = -1;
    }
}
