﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using pms_modal;



namespace pmsDataGridView
{
    public partial class Form1 : Form
    {
        public BearingList bearinglist = new BearingList();
        public enum ColumnType {ID,BEARING,BRAND,QUANTITY,SEAL,COST,PRICE,ORDER,INDEX}
        public Form1()
        {
            InitializeComponent();
        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            fillgrids();
        }

        #region My own functions
        private void fillgrids()
        {           
            bearinglist.load();
            //bearinglist.Bearings[9].Brand = Bearing.BrandType.Normal;
            for (int i = 0; i < bearinglist.Count; i++)
            {
                Bearing b = bearinglist.Bearings[i];
                dataGridView1.Rows.Add();
                //b.Brand = pmsDataGridView.Bearing.BrandType.NSK;
                //bearinglist.Bearings[i].ID = b.Inner.ToString("00") + b.Outer.ToString("00") + b.Thickness.ToString("00") + (b.Flanged ? "1" : "0") + b.Brand.GetHashCode().ToString() + b.Seal.GetHashCode().ToString();
                    //+ b.brand. + b.Seal.ToString("0");
                //bearinglist.Bearings[i].Index = i;
                dataGridView1.Rows[i].Cells[(int)ColumnType.ID].Value = bearinglist.Bearings[i].ID;
                dataGridView1.Rows[i].Cells[(int)ColumnType.BEARING].Value = bearinglist.Bearings[i].name;
                dataGridView1.Rows[i].Cells[(int)ColumnType.BRAND].Value = bearinglist.Bearings[i].Brand;
                dataGridView1.Rows[i].Cells[(int)ColumnType.QUANTITY].Value = bearinglist.Bearings[i].quantity.ToString("000");
                dataGridView1.Rows[i].Cells[(int)ColumnType.SEAL].Value = bearinglist.Bearings[i].Seal.ToString();                
                dataGridView1.Rows[i].Cells[(int)ColumnType.COST].Value = bearinglist.Bearings[i].prime_cost.ToString("0.00");
                dataGridView1.Rows[i].Cells[(int)ColumnType.PRICE].Value = bearinglist.Bearings[i].Price.ToString("0.00");
                dataGridView1.Rows[i].Cells[(int)ColumnType.INDEX].Value = bearinglist.Bearings[i].Index.ToString();
            }

        }

        private void SaveBearings()
        {
            BearingList newbl = new BearingList();         
            for (int i = 0; i < bearinglist.Count; i++)
            {
                int idx = Convert.ToInt32(dataGridView1.Rows[i].Cells[(int)ColumnType.INDEX].Value);
                Bearing b = bearinglist.Bearings[idx];
                b.Index = i;
                newbl.add(b);
                //newbl.Bearings[i].Index = i;
            }
            newbl.save();
            MessageBox.Show("Data have been saved");
        }
        #endregion

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {

            switch (MessageBox.Show("Do you want to save the changes?",
                                        "Before closing...",
                                        MessageBoxButtons.YesNoCancel,
                                        MessageBoxIcon.Question))
            {
                case DialogResult.Yes:
                    // "Yes" save
                    SaveBearings();
                    break;

                case DialogResult.No:
                    // "No" don't save
                    break;

                case DialogResult.Cancel:
                    // "Cancel" closing form
                    e.Cancel = true;
                    break;
            }
        }

        private void toolStripButtonOpen_Click(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "xml files (*.xml)|*.xml";
            openFileDialog1.RestoreDirectory = true;
            openFileDialog1.FileName = "";

            openFileDialog1.ShowDialog();
        }

        private void toolStripButtonOK_Click(object sender, EventArgs e)
        {

            for (int i = 0; i < bearinglist.Count; i++)
            {
                object order_mount = dataGridView1.Rows[i].Cells[(int)ColumnType.ORDER].Value;
                if (order_mount != null)
                {
                    int idx =Convert.ToInt32(dataGridView1.Rows[i].Cells[(int)ColumnType.INDEX].Value);
                    bearinglist.Bearings[idx].quantity -= Convert.ToInt32(order_mount);
                    //update the remaining quantity
                    dataGridView1.Rows[i].Cells[(int)ColumnType.QUANTITY].Value = bearinglist.Bearings[idx].quantity.ToString();
                    //clear the order cell
                    dataGridView1.Rows[i].Cells[(int)ColumnType.ORDER].Value = null;
                }
            }

        }

        private void toolStripButtonSave_Click(object sender, EventArgs e)
        {
            SaveBearings();
        }
    }
}
