﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace pmsDataGridView
{
    public partial class PriceListForm : Form
    {
        public enum GridColumnType { QUANTITY, PRICE }
        public PriceListForm()
        {
            InitializeComponent();
            OKbtnPressed = false;            
        }
        public PriceListForm(Product product)
            : this()
        {
            local_product = product;
            //fill up the form
            for (int i = 0; i < product.PriceListQty.Count; i++)
            {
                PriceListDataGridView.Rows.Add();
                PriceListDataGridView.Rows[i].Cells[(int)GridColumnType.QUANTITY].Value = product.PriceListQty[i];
                if (product.PriceListPrice.Count > i)
                {
                    PriceListDataGridView.Rows[i].Cells[(int)GridColumnType.PRICE].Value = product.PriceListPrice[i];
                }
                
            }
        }

        private void OKButton_Click(object sender, EventArgs e)
        {
            OKbtnPressed = true;
            PriceListQty.Clear();
            PriceListPrice.Clear();
            string col1str, col2str;
            bool Col1isInt = false;
            bool Col2isDouble = false;
            int IntNum;
            double DoubleNum;
            for (int i = 0; i<PriceListDataGridView.RowCount-1; i++)
            {
                col1str = PriceListDataGridView.Rows[i].Cells[(int)GridColumnType.QUANTITY].Value.ToString();
                Col1isInt = int.TryParse(col1str, out IntNum);

                if (PriceListDataGridView.Rows[i].Cells[(int)GridColumnType.PRICE].Value != null)
                {
                    col2str = PriceListDataGridView.Rows[i].Cells[(int)GridColumnType.PRICE].Value.ToString();
                    Col2isDouble = double.TryParse(col2str, out DoubleNum);



                    //if both columns format satisfied, go ahead and grid the numbers
                    if (Col1isInt && Col2isDouble)
                    {
                        PriceListQty.Add(Convert.ToInt32(col1str));
                        PriceListPrice.Add(Convert.ToDouble(col2str));
                    }
                    else
                    {
                        MessageBox.Show("One or more rows have incorrect format, those rows are ignored.");
                        return;
                    }
                }
                else
                {
                    MessageBox.Show("The form is incomplete so do nothing.");
                    Close();
                    return;
                }
            }
            //copy the values of the grid to the product attributes
            local_product.PriceListQty = PriceListQty.ToList();
            local_product.PriceListPrice = PriceListPrice.ToList();
            Close();
        }

        public bool OKbtnPressed;
        public Product local_product;
        public List<int> PriceListQty = new List<int>();
        public List<double> PriceListPrice = new List<double>();

        private void CancelButton_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
