using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace pmsDataGridView
{
    public partial class ProductEditForm : Form
    {
        public ProductEditForm()
        {
            InitializeComponent();
            PrimeCostTextBox.Text = "0.9";
            CommentTextbox.Text = "No Comment";
            SealTypeBox.SelectedIndex = 1;//double-sided shield is more common than single-sided shield
            BrandTypeBox.SelectedIndex = 0;
        }

        public ProductEditForm(Product b, int selected_row_index)
            : this()
        {
            InnerTextBox.Text = b.Inner.ToString();
            OuterTextBox.Text = b.Outer.ToString();
            ThicknessTextBox.Text = b.Thickness.ToString();
            QuantityTextBox.Text = b.quantity.ToString();
            NameTextBox.Text = b.name;
            SealTypeBox.SelectedIndex = (int)b.Seal;
            BrandTypeBox.SelectedIndex = (int)b.Brand;
            PrimeCostTextBox.Text = b.prime_cost.ToString();
            PriceTextBox.Text = b.Price.ToString();
            FlangedCheckBox.Checked = b.Flanged;
            ClustercheckBox.Checked = b.cluster;
            CommentTextbox.Text = b.comment;
            DescriptionTextBox.Text = b.Desription;
            OurLinkTextBox.Text = b.ourLink;
            SupplerLinkTextBox.Text = b.supplerLink;
            pEditMode = true;
            //pEditingBearingIndex = b.Index;
            CodeTextBox.Text = b.Code;

            //most likely its in edit mode if this function is called, so make the copy of the orginal bearing first
            newproduct = b;
            selected_bearing_row_index = selected_row_index;
        }
        public bool EditMode
        {
            get { return pEditMode; }
            set { pEditMode = value; }            
        }
        private void Cancel_Click(object sender, EventArgs e)
        {
            newproduct = null;
            Hide();
        }

        private void Ok_Click(object sender, EventArgs e)
        {
            Product.SealType st = new Product.SealType();
            Product.BrandType bt = new Product.BrandType();
            try
            {
                if (!pEditMode)
                {
                    //get the seal and brand type by value
                    st = (Product.SealType)System.Enum.Parse(typeof(Product.SealType), SealTypeBox.SelectedIndex.ToString());
                    bt = (Product.BrandType)System.Enum.Parse(typeof(Product.BrandType), BrandTypeBox.SelectedIndex.ToString());
                    newproduct = new Product(Convert.ToDouble(InnerTextBox.Text), Convert.ToDouble(OuterTextBox.Text),
                        Convert.ToDouble(ThicknessTextBox.Text), st, FlangedCheckBox.Checked, bt, Convert.ToInt32(QuantityTextBox.Text),
                        Convert.ToDouble(PrimeCostTextBox.Text), Convert.ToDouble(PriceTextBox.Text),
                        CommentTextbox.Text);
                    //update the product name according to the name text box
                    if (NameTextBox.Text != "")
                    {
                        newproduct.name = NameTextBox.Text;
                    }
                }

                //newly added bearing index will be asigned in the add function of the bearing list
                if (pEditMode)
                {//update the properties of the bearings according to the info filled in the form
                    //get the seal and brand type by value
                    st = (Product.SealType)System.Enum.Parse(typeof(Product.SealType), SealTypeBox.SelectedIndex.ToString());
                    bt = (Product.BrandType)System.Enum.Parse(typeof(Product.BrandType), BrandTypeBox.SelectedIndex.ToString());
                    newproduct.Seal = st;
                    newproduct.Brand = bt;
                    newproduct.Inner = Convert.ToDouble(InnerTextBox.Text);
                    newproduct.Outer = Convert.ToDouble(OuterTextBox.Text);
                    newproduct.Thickness = Convert.ToDouble(ThicknessTextBox.Text);
                    newproduct.Flanged = FlangedCheckBox.Checked;
                    newproduct.quantity = Convert.ToInt32(QuantityTextBox.Text);
                    newproduct.prime_cost = Convert.ToDouble(PrimeCostTextBox.Text);
                    newproduct.Price = Convert.ToDouble(PriceTextBox.Text);
                    newproduct.comment = CommentTextbox.Text;
                    //newly added fileds
                    //newproduct.Code = CodeTextBox.Text;                    
                    //newproduct.Desription = DescriptionTextBox.Text;                    
                    //newproduct.cluster = ClustercheckBox.Checked;
                    newproduct.name = NameTextBox.Text;   
                    //update the ID number
                    newproduct.make_ID();
                }
                //this is a newly added bearing properties, so is excluded in the bearing constructor
                newproduct.Code = CodeTextBox.Text;
                //this is another newly added bearing properties, so is excluded in the bearing constructor
                newproduct.Desription = DescriptionTextBox.Text;
                //this is another newly added bearing properties, so is excluded in the bearing constructor
                newproduct.cluster = ClustercheckBox.Checked;
                //this is another newly added bearing properties, so is excluded in the bearing constructor
                newproduct.toPackList = ToPackListTextBox.Text;
                //update the product name according to the name text box
                newproduct.ourLink = OurLinkTextBox.Text;
                //update the product name according to the name text box
                newproduct.supplerLink = SupplerLinkTextBox.Text;
                Close();
            }
            catch (Exception exception)
            {
                exception.Source.ToString();//effectless, just to suppress warnings.
                MessageBox.Show("Some fields are invalid, please check. ");
            }
        }

        public Product newproduct = null;        
        private bool pEditMode = false;
        private int pEditingBearingIndex = -1;
        public int selected_bearing_row_index = -1;

        private void EditPriceListButton_Click(object sender, EventArgs e)
        {
            PriceListForm AddForm = new PriceListForm(newproduct);
            AddForm.Show();
            AddForm.FormClosed += new FormClosedEventHandler(EditPriceListForm_FormClosed);
        }
        private void EditPriceListForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            PriceListForm addform = (PriceListForm)sender;
            if (addform.OKbtnPressed)
            {
                //grip the price list

            }
        }
    }
}