﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace pmsDataGridView
{
    public partial class SelectFromProductlistForm : Form
    {
        public SelectFromProductlistForm()
        {
            InitializeComponent();
        }
        public SelectFromProductlistForm(ProductList productlist, ProductList orderlist)
            : this()
        {                                    
            this.productlist = productlist; //not sure if I should use copy
            this.orderlist = orderlist;
            //check if there is order on the list, if so, add it on the list

            for (int i = 0; i < orderlist.Count; i++)
            {
                if (orderlist[i].Order > 0)
                {
                    productlist[orderlist[i].MasterListIndex].Order = orderlist[i].Order;
                }
            }
            
            this.productlist.fill_grid(ProductlistGrid);
        }

        

        private void SearchTextBox_TextChanged(object sender, EventArgs e)
        {
            string SearchKeyWord = SearchTextBox.Text;
            productlist.ShowSearchResults(ProductlistGrid, SearchKeyWord);
        }

        private void OkButton_Click(object sender, EventArgs e)
        {            
            for (int i = 0; i < productlist.Count; i++)
            {
                if (productlist[i].Order > 0)
                {
                    int containedItemIndex = orderlist.contains(productlist[i]);
                    if ( containedItemIndex == -1 )
                    {
                        Product newOrder = new Product();
                        newOrder.copy(productlist[i]);
                        orderlist.add(newOrder);
                    }
                    else
                    {
                        orderlist[containedItemIndex].Order = productlist[i].Order;
                    }
                    //reset order to zero
                    productlist[i].Order = 0;
                }
            }
            OkPressed = true;
            Close();
        }


        private void ProductlistGrid_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            int sri = e.RowIndex;
            int selected_col = e.ColumnIndex;
            //this getting the list index from the row index should be written as a function for all the list and grid
            int spi = Convert.ToInt32(ProductlistGrid.Rows[sri].Cells[(int)pmsDataGridView.Product.GridColumnType.INDEX].Value);            
            switch (selected_col)
            {
                case ((int)pmsDataGridView.Product.GridColumnType.ORDER):
                    productlist[spi].update_order_from_grid(ProductlistGrid, sri);
                    break;
            }
        }


        public ProductList productlist = new ProductList();
        public ProductList orderlist = new ProductList();
        public bool OkPressed = false;
    }
}
