using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.IO;
using System.Xml;
using System.Xml.Serialization;


namespace pms_modal
{
   
    public class Item 
    {
        
        #region Constructors and Distructor

        public Item() { }

        public Item(string Name, int Quantity, double PrimeCost, string Comment)
        {
            this.Name = Name;
            this.Quantity = Quantity;
            this.PrimeCost = PrimeCost;
            this.Comment = Comment;
        }
        
        ~Item() { }

        #endregion
        
        #region get & set porperties
        
        [XmlAttribute("Name")]
        public string name 
        { 
            get { return Name;}
            set { Name = value;}
        }

        [XmlElement("Quantity")]
        public int quantity
        {
            get { return Quantity; }
            set { Quantity = value; }
        }

        [XmlElement("PrimeCost")]
        public double prime_cost
        { 
            get { return PrimeCost;}
            set { PrimeCost = value;}
        }

        [XmlElement("Comment")]
        public string comment
        {
            get { return Comment; }
            set { Comment = value; }
        }

        #endregion

        #region Private variables

        
        private string Name = "";
        private int Quantity = 0;        
        private double PrimeCost = 0.00;       
        private string Comment = "";

        #endregion
    }
}



namespace pms_modal
{
 
    public class ItemList
    {
        #region Constructor and Distructor

        public ItemList() 
        {
            itemlist = new ArrayList();
        }

        ~ItemList(){ }

        #endregion

        #region Methods

        public void add(Item item) 
        {
            itemlist.Add(item);
        }
        
        public void add(string Name, int Quantity, double PrimeCost, string Comment) 
        {
            Item i = new Item(Name,Quantity,PrimeCost,Comment);
            itemlist.Add(i);
        }

        public Item get_item(int location) //0 based index  
        {
            if (location < itemlist.Count)
            {
                return (Item)itemlist[location];
            }
            else return null;
        }            
        
        public int item_count 
        {
            get { return itemlist.Count; }
        }

        public void delete_item(int location) //0 based index  
        {
            if (location < itemlist.Count)
            {
                itemlist.RemoveAt(location);
            }
            else return;
        }

        public void copy(ItemList sample) 
        {
            this.itemlist = sample.itemlist;
        }

        //Indexer
        public Item this[int location] 
        {
            get { return (Item)itemlist[location]; }
            set { itemlist[location] = value; }
        }

        [XmlIgnore]
        public string data_path 
        {
            get { return ItemPath; }
            set { ItemPath = value; }
        }

        #region XML read and write methods

        [XmlElement("Item")]
        //this is a property, when use: item.items[0], returns an item
        public Item[] Items
        {
            get
            {
                Item[] items = new Item[itemlist.Count];
                itemlist.CopyTo(items);
                return items;
            }

            set
            {
                if (value == null) return;
                Item[] items = (Item[])value;
                itemlist.Clear();
                foreach (Item item in items)
                {
                    itemlist.Add(item);
                }
            }
        }
        
        public virtual void save()
        {
         
            // Serialization
            XmlSerializer ser = new XmlSerializer(typeof(ItemList));
            TextWriter xml_write = new StreamWriter(ItemPath);

            ser.Serialize(xml_write, this);
            xml_write.Close();
        }
        
        public virtual void load()
        {
            ItemList temp = new ItemList();
            // Deserialization
            
            XmlSerializer ser = new XmlSerializer(typeof(ItemList));

            TextReader xml_read = new StreamReader(ItemPath);

            temp = (ItemList)ser.Deserialize(xml_read);

            copy(temp);
            xml_read.Close();

        }

        #endregion

        #endregion

        #region Private variables

        private ArrayList itemlist;
        private string ItemPath = @"../../ProgramData/ProductData.xml";

        #endregion
    }
}