/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NativeWindowFactoryImpl;
import jogamp.nativewindow.ResourceToolkitLock;

public abstract class NativeWindowFactory {
    protected static final boolean DEBUG;
    public static final String TYPE_EGL;
    public static final String TYPE_WINDOWS;
    public static final String TYPE_X11;
    public static final String TYPE_BCM_VC_IV;
    public static final String TYPE_ANDROID;
    public static final String TYPE_MACOSX;
    public static final String TYPE_AWT;
    public static final String TYPE_DEFAULT;
    private static final String nativeWindowingTypePure;
    private static final String nativeWindowingTypeCustom;
    private static NativeWindowFactory defaultFactory;
    private static Map<Class<?>, NativeWindowFactory> registeredFactories;
    private static Class<?> nativeWindowClass;
    private static boolean isAWTAvailable;
    private static final String JAWTUtilClassName = "jogamp.nativewindow.jawt.JAWTUtil";
    private static final String X11UtilClassName = "jogamp.nativewindow.x11.X11Util";
    private static final String OSXUtilClassName = "jogamp.nativewindow.macosx.OSXUtil";
    private static final String GDIClassName = "jogamp.nativewindow.windows.GDIUtil";
    private static ToolkitLock jawtUtilJAWTToolkitLock;
    private static boolean requiresToolkitLock;
    private static boolean desktopHasThreadingIssues;
    private static volatile boolean isJVMShuttingDown;
    static boolean initialized;

    protected NativeWindowFactory() {
    }

    private static final boolean guessBroadcomVCIV() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            private final File vcliblocation = new File("/opt/vc/lib/libbcm_host.so");

            @Override
            public Boolean run() {
                if (this.vcliblocation.isFile()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private static String _getNativeWindowingType() {
        switch (Platform.OS_TYPE) {
            case ANDROID: {
                return TYPE_ANDROID;
            }
            case MACOS: {
                return TYPE_MACOSX;
            }
            case WINDOWS: {
                return TYPE_WINDOWS;
            }
            case OPENKODE: {
                return TYPE_EGL;
            }
        }
        if (NativeWindowFactory.guessBroadcomVCIV()) {
            return TYPE_BCM_VC_IV;
        }
        return TYPE_X11;
    }

    private static void initSingletonNativeImpl(ClassLoader classLoader) {
        String string = TYPE_X11 == nativeWindowingTypePure ? X11UtilClassName : (TYPE_WINDOWS == nativeWindowingTypePure ? GDIClassName : (TYPE_MACOSX == nativeWindowingTypePure ? OSXUtilClassName : null));
        if (null != string) {
            ReflectionUtil.callStaticMethod((String)string, (String)"initSingleton", null, null, (ClassLoader)classLoader);
            Boolean bl = (Boolean)ReflectionUtil.callStaticMethod((String)string, (String)"requiresToolkitLock", null, null, (ClassLoader)classLoader);
            requiresToolkitLock = bl;
            Boolean bl2 = (Boolean)ReflectionUtil.callStaticMethod((String)string, (String)"hasThreadingIssues", null, null, (ClassLoader)classLoader);
            desktopHasThreadingIssues = bl2;
        } else {
            requiresToolkitLock = false;
            desktopHasThreadingIssues = false;
        }
    }

    private static void shutdownNativeImpl(ClassLoader classLoader) {
        String string = TYPE_X11 == nativeWindowingTypePure ? X11UtilClassName : (TYPE_WINDOWS == nativeWindowingTypePure ? GDIClassName : (TYPE_MACOSX == nativeWindowingTypePure ? OSXUtilClassName : null));
        if (null != string) {
            ReflectionUtil.callStaticMethod((String)string, (String)"shutdown", null, null, (ClassLoader)classLoader);
        }
    }

    public static synchronized void initSingleton() {
        if (!initialized) {
            Object object;
            initialized = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.initSingleton()");
            }
            ClassLoader classLoader = NativeWindowFactory.class.getClassLoader();
            isAWTAvailable = false;
            if (Platform.AWT_AVAILABLE && ReflectionUtil.isClassAvailable((String)"com.jogamp.nativewindow.awt.AWTGraphicsDevice", (ClassLoader)classLoader) && null != (object = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    try {
                        Class<?> clazz = Class.forName(NativeWindowFactory.JAWTUtilClassName, true, NativeWindowFactory.class.getClassLoader());
                        Method method = clazz.getDeclaredMethod("isHeadlessMode", null);
                        method.setAccessible(true);
                        Method method2 = clazz.getDeclaredMethod("initSingleton", null);
                        method2.setAccessible(true);
                        Method method3 = clazz.getDeclaredMethod("getJAWTToolkitLock", new Class[0]);
                        method3.setAccessible(true);
                        return new Method[]{method2, method, method3};
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            exception.printStackTrace();
                        }
                        return null;
                    }
                }
            }))) {
                Method method = object[0];
                Method method2 = object[1];
                Method method3 = object[2];
                ReflectionUtil.callMethod(null, (Method)method, (Object[])new Object[0]);
                Object object2 = ReflectionUtil.callMethod(null, (Method)method2, (Object[])new Object[0]);
                if (!(object2 instanceof Boolean)) {
                    throw new RuntimeException("JAWTUtil.isHeadlessMode() didn't return a Boolean");
                }
                isAWTAvailable = ((Boolean)object2).equals(Boolean.FALSE);
                object2 = ReflectionUtil.callMethod(null, (Method)method3, (Object[])new Object[0]);
                if (object2 instanceof ToolkitLock) {
                    jawtUtilJAWTToolkitLock = (ToolkitLock)object2;
                } else {
                    throw new RuntimeException("JAWTUtil.getJAWTToolkitLock() didn't return a ToolkitLock");
                }
            }
            NativeWindowFactory.initSingletonNativeImpl(classLoader);
            registeredFactories = Collections.synchronizedMap(new HashMap());
            object = new NativeWindowFactoryImpl();
            nativeWindowClass = NativeWindow.class;
            NativeWindowFactory.registerFactory(nativeWindowClass, (NativeWindowFactory)object);
            defaultFactory = object;
            if (isAWTAvailable) {
                NativeWindowFactory.registerFactory(ReflectionUtil.getClass((String)"java.awt.Component", (boolean)false, (ClassLoader)classLoader), (NativeWindowFactory)object);
            }
            if (DEBUG) {
                System.err.println("NativeWindowFactory requiresToolkitLock " + requiresToolkitLock + ", desktopHasThreadingIssues " + desktopHasThreadingIssues);
                System.err.println("NativeWindowFactory isAWTAvailable " + isAWTAvailable + ", defaultFactory " + object);
            }
            GraphicsConfigurationFactory.initSingleton();
        }
    }

    public static synchronized void shutdown(boolean bl) {
        isJVMShuttingDown = bl;
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.shutdown() START: JVM Shutdown " + isJVMShuttingDown);
        }
        if (initialized) {
            initialized = false;
            if (null != registeredFactories) {
                registeredFactories.clear();
                registeredFactories = null;
            }
            GraphicsConfigurationFactory.shutdown();
        }
        NativeWindowFactory.shutdownNativeImpl(NativeWindowFactory.class.getClassLoader());
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.shutdown() END JVM Shutdown " + isJVMShuttingDown);
        }
    }

    public static final boolean isJVMShuttingDown() {
        return isJVMShuttingDown;
    }

    public static boolean requiresToolkitLock() {
        return requiresToolkitLock;
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getNativeWindowType(boolean bl) {
        return bl ? nativeWindowingTypeCustom : nativeWindowingTypePure;
    }

    public static void setDefaultFactory(NativeWindowFactory nativeWindowFactory) {
        defaultFactory = nativeWindowFactory;
    }

    public static NativeWindowFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static ToolkitLock getAWTToolkitLock() {
        return jawtUtilJAWTToolkitLock;
    }

    public static ToolkitLock getNullToolkitLock() {
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock getDefaultToolkitLock() {
        return NativeWindowFactory.getDefaultToolkitLock(NativeWindowFactory.getNativeWindowType(false));
    }

    public static ToolkitLock getDefaultToolkitLock(String string) {
        if (requiresToolkitLock) {
            if (TYPE_AWT == string && NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.getAWTToolkitLock();
            }
            return ResourceToolkitLock.create();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock getDefaultToolkitLock(String string, long l) {
        if (requiresToolkitLock) {
            if (TYPE_AWT == string && NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.getAWTToolkitLock();
            }
            return ResourceToolkitLock.create();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static NativeWindowFactory getFactory(Class<?> clazz) throws IllegalArgumentException {
        if (nativeWindowClass.isAssignableFrom(clazz)) {
            return registeredFactories.get(nativeWindowClass);
        }
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            NativeWindowFactory nativeWindowFactory = registeredFactories.get(clazz2);
            if (nativeWindowFactory == null) continue;
            return nativeWindowFactory;
        }
        throw new IllegalArgumentException("No registered NativeWindowFactory for class " + clazz.getName());
    }

    protected static void registerFactory(Class<?> clazz, NativeWindowFactory nativeWindowFactory) {
        if (DEBUG) {
            System.err.println("NativeWindowFactory.registerFactory() " + clazz + " -> " + nativeWindowFactory);
        }
        registeredFactories.put(clazz, nativeWindowFactory);
    }

    public static NativeWindow getNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException, NativeWindowException {
        if (object == null) {
            throw new IllegalArgumentException("Null window object");
        }
        return NativeWindowFactory.getFactory(object.getClass()).getNativeWindowImpl(object, abstractGraphicsConfiguration);
    }

    protected abstract NativeWindow getNativeWindowImpl(Object var1, AbstractGraphicsConfiguration var2) throws IllegalArgumentException;

    public static OffscreenLayerSurface getOffscreenLayerSurface(NativeSurface nativeSurface, boolean bl) {
        if (nativeSurface instanceof OffscreenLayerSurface && (!bl || nativeSurface instanceof OffscreenLayerOption)) {
            OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeSurface);
            return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
        }
        if (nativeSurface instanceof NativeWindow) {
            for (NativeWindow nativeWindow = ((NativeWindow)nativeSurface).getParent(); null != nativeWindow; nativeWindow = nativeWindow.getParent()) {
                if (!(nativeWindow instanceof OffscreenLayerSurface) || bl && !(nativeWindow instanceof OffscreenLayerOption)) continue;
                OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeWindow);
                return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
            }
        }
        return null;
    }

    public static boolean isNativeVisualIDValidForProcessing(int n) {
        return TYPE_X11 != NativeWindowFactory.getNativeWindowType(false) || 0 != n;
    }

    static {
        TYPE_EGL = ".egl".intern();
        TYPE_WINDOWS = ".windows".intern();
        TYPE_X11 = ".x11".intern();
        TYPE_BCM_VC_IV = ".bcm.vc.iv".intern();
        TYPE_ANDROID = ".android".intern();
        TYPE_MACOSX = ".macosx".intern();
        TYPE_AWT = ".awt".intern();
        TYPE_DEFAULT = ".default".intern();
        isJVMShuttingDown = false;
        Platform.initSingleton();
        DEBUG = Debug.debug("NativeWindow");
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: NativeWindowFactory.<init>");
        }
        nativeWindowingTypePure = NativeWindowFactory._getNativeWindowingType();
        String string = Debug.getProperty("nativewindow.ws.name", true);
        nativeWindowingTypeCustom = null == string || string.length() == 0 ? nativeWindowingTypePure : string.intern();
        initialized = false;
    }
}

