/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GL3;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLUniformData;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLFBODrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.CGLExt;
import jogamp.opengl.macosx.cgl.CGLExtImpl;
import jogamp.opengl.macosx.cgl.CGLExtProcAddressTable;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXCGLGraphicsConfiguration;

public abstract class MacOSXCGLContext
extends GLContextImpl {
    static final boolean isTigerOrLater;
    static final boolean isLionOrLater;
    private static final String shaderBasename = "texture01_xxx";
    private boolean haveSetOpenGLMode = false;
    private MacOSXCGLDrawable.GLBackendType openGLMode = MacOSXCGLDrawable.GLBackendType.NSOPENGL;
    protected GLBackendImpl impl;
    private CGLExt _cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;

    static boolean isGLProfileSupported(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = 0 != (2 & n);
        boolean bl3 = bl = 0 != (4 & n);
        if (3 == n2 && 1 <= n3 && n3 <= 2) {
            if (!isLionOrLater) {
                return false;
            }
            if (bl2) {
                return false;
            }
            return bl;
        }
        return n2 < 3;
    }

    static int GLProfile2CGLOGLProfileValue(int n, int n2, int n3) {
        boolean bl;
        if (!MacOSXCGLContext.isGLProfileSupported(n, n2, n3)) {
            throw new GLException("OpenGL profile not supported: " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@GLProfile2CGLOGLProfileVersion"));
        }
        boolean bl2 = bl = 0 != (4 & n);
        if (n2 == 3 && n3 >= 1 && bl) {
            return 12800;
        }
        return 4096;
    }

    private static ShaderProgram createCALayerShader(GL3 gL3) {
        ShaderProgram shaderProgram = new ShaderProgram();
        ShaderCode shaderCode = ShaderCode.create(gL3, 35633, MacOSXCGLContext.class, "../../shader", "../../shader/bin", shaderBasename, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL3, 35632, MacOSXCGLContext.class, "../../shader", "../../shader/bin", shaderBasename, true);
        shaderCode.defaultShaderCustomization(gL3, true, "\nprecision highp float;\nprecision highp int;\n");
        shaderCode2.defaultShaderCustomization(gL3, true, "\nprecision mediump float;\nprecision mediump int;\n/*precision lowp sampler2D;*/\n");
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL3, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        shaderProgram.useProgram(gL3, true);
        PMVMatrix pMVMatrix = new PMVMatrix();
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        GLUniformData gLUniformData = new GLUniformData("mgl_PMVMatrix", 4, 4, pMVMatrix.glGetPMvMatrixf());
        gLUniformData.setLocation(gL3.glGetUniformLocation(shaderProgram.program(), gLUniformData.getName()));
        gL3.glUniform(gLUniformData);
        shaderProgram.useProgram(gL3, false);
        return shaderProgram;
    }

    protected MacOSXCGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
        this.initOpenGLImpl(this.getOpenGLMode());
    }

    @Override
    protected void resetStates() {
        this.cglExtProcAddressTable = null;
        super.resetStates();
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    protected boolean isNSContext() {
        return null != this.impl ? this.impl.isNSContext() : this.openGLMode == MacOSXCGLDrawable.GLBackendType.NSOPENGL;
    }

    public CGLExt getCGLExt() {
        if (this._cglExt == null) {
            this._cglExt = new CGLExtImpl(this);
        }
        return this._cglExt;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getCGLExtProcAddressTable();
    }

    public final CGLExtProcAddressTable getCGLExtProcAddressTable() {
        return this.cglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return null;
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        if (!MacOSXCGLContext.isGLProfileSupported(n, n2, n3)) {
            if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: Not supported " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation on OSX " + Platform.getOSVersionNumber()));
            }
            return 0L;
        }
        long l2 = this.impl.create(l, n, n2, n3);
        if (0L != l2) {
            if (!this.impl.makeCurrent(l2)) {
                if (DEBUG) {
                    System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARB couldn't make current " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                this.impl.release(l2);
                this.impl.destroy(l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: OK " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl + " on OSX " + Platform.getOSVersionNumber());
            }
        } else if (DEBUG) {
            System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: NO " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation on OSX " + Platform.getOSVersionNumber()));
        }
        return l2;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        this.impl.release(l);
        this.impl.destroy(l);
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return false;
    }

    protected long createImplPreset(GLContextImpl gLContextImpl) throws GLException {
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration;
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        long l = 0L;
        if (gLContextImpl != null) {
            this.setOpenGLMode(((MacOSXCGLContext)gLContextImpl).getOpenGLMode());
            l = gLContextImpl.getHandle();
            if (l == 0L) {
                throw new GLException("GLContextShareSet returned a NULL OpenGL context");
            }
        }
        if ((gLCapabilitiesImmutable = (GLCapabilitiesImmutable)(macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration()).getChosenCapabilities()).getPbufferFloatingPointBuffers() && !isTigerOrLater) {
            throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (gLProfile.isGLES1() || gLProfile.isGLES2() || gLProfile.isGL4() || gLProfile.isGL3() && !isLionOrLater) {
            throw new GLException("OpenGL profile not supported on MacOSX " + Platform.getOSVersionNumber() + ": " + gLProfile);
        }
        if (DEBUG) {
            System.err.println("Share context is " + MacOSXCGLContext.toHexString(l) + " for " + this);
        }
        return l;
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) throws GLException {
        long l = this.createImplPreset(gLContextImpl);
        this.contextHandle = this.createContextARB(l, true);
        return 0L != this.contextHandle;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        if (!this.impl.makeCurrent(this.contextHandle)) {
            throw new GLException("Error making Context current: " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!this.impl.release(this.contextHandle)) {
            throw new GLException("Error releasing OpenGL Context: " + this);
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        if (!this.impl.destroy(this.contextHandle)) {
            throw new GLException("Error destroying OpenGL Context: " + this);
        }
    }

    @Override
    protected void contextRealized(boolean bl) {
        if (bl) {
            super.contextRealized(true);
            this.impl.contextRealized(true);
        } else {
            this.impl.contextRealized(false);
            super.contextRealized(false);
        }
    }

    void drawableChangedNotify() {
        if (0L != this.contextHandle) {
            this.impl.drawableChangedNotify();
        }
    }

    void detachPBuffer() {
        this.impl.detachPBuffer();
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        if (this.isNSContext() != ((MacOSXCGLContext)gLContext).isNSContext()) {
            throw new GLException("Source/Destination OpenGL Context tyoe mismatch: source " + gLContext + ", dest: " + this);
        }
        if (!this.impl.copyImpl(gLContext.getHandle(), n)) {
            throw new GLException("Error copying OpenGL Context: source " + gLContext + ", dest: " + this);
        }
    }

    protected void swapBuffers() {
        if (!this.impl.swapBuffers()) {
            throw new GLException("Error swapping buffers: " + this);
        }
    }

    @Override
    protected boolean setSwapIntervalImpl(int n) {
        return this.impl.setSwapInterval(n);
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "MacOSX-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(MacOSXCGLContext.getThreadName() + ": Initializing CGL extension address table: " + string);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.cglExtProcAddressTable = (CGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": GLContext CGL ProcAddressTable reusing key(" + string + ") -> " + MacOSXCGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.cglExtProcAddressTable = new CGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getCGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getCGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(MacOSXCGLContext.getThreadName() + ": GLContext CGL ProcAddressTable mapping key(" + string + ") -> " + MacOSXCGLContext.toHexString(((Object)((Object)this.getCGLExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        return new StringBuilder();
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    @Override
    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    @Override
    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void setOpenGLMode(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        if (gLBackendType == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroyImpl();
        ((MacOSXCGLDrawable)this.drawable).setOpenGLMode(gLBackendType);
        if (DEBUG) {
            System.err.println("MacOSXCGLContext: Switching context mode " + (Object)((Object)this.openGLMode) + " -> " + (Object)((Object)gLBackendType));
        }
        this.initOpenGLImpl(gLBackendType);
        this.openGLMode = gLBackendType;
        this.haveSetOpenGLMode = true;
    }

    public final MacOSXCGLDrawable.GLBackendType getOpenGLMode() {
        return this.openGLMode;
    }

    protected void initOpenGLImpl(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        switch (gLBackendType) {
            case NSOPENGL: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case CGL: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + (Object)((Object)gLBackendType));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        super.append(stringBuilder);
        stringBuilder.append(", mode ");
        stringBuilder.append((Object)this.openGLMode);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    static {
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        isTigerOrLater = versionNumber.getMajor() > 10 || versionNumber.getMajor() == 10 && versionNumber.getMinor() >= 4;
        isLionOrLater = versionNumber.getMajor() > 10 || versionNumber.getMajor() == 10 && versionNumber.getMinor() >= 7;
    }

    class CGLImpl
    implements GLBackendImpl {
        CGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return false;
        }

        @Override
        public void drawableChangedNotify() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long create(long l, int n, int n2, int n3) {
            long l2 = 0L;
            MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)MacOSXCGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)macOSXCGLGraphicsConfiguration.getChosenCapabilities();
            long l3 = MacOSXCGLGraphicsConfiguration.GLCapabilities2CGLPixelFormat(gLCapabilitiesImmutable, n, n2, n3);
            if (l3 == 0L) {
                throw new GLException("Unable to allocate pixel format with requested GLCapabilities");
            }
            try {
                int n4;
                PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
                if (GLContext.DEBUG) {
                    System.err.println("Share context for CGL-based pbuffer context is " + MacOSXCGLContext.toHexString(l));
                }
                if ((n4 = CGL.CGLCreateContext(l3, l, pointerBuffer)) != 0) {
                    throw new GLException("Error code " + n4 + " while creating context");
                }
                l2 = pointerBuffer.get(0);
                if (0L != l2) {
                    GLCapabilities gLCapabilities = MacOSXCGLGraphicsConfiguration.CGLPixelFormat2GLCapabilities(l3);
                    gLCapabilities = GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(gLCapabilities, gLCapabilitiesImmutable.isBackgroundOpaque());
                    gLCapabilities.setFBO(false);
                    gLCapabilities.setPBuffer(gLCapabilities.isPBuffer() && !gLCapabilitiesImmutable.isOnscreen());
                    gLCapabilities.setBitmap(false);
                    gLCapabilities.setOnscreen(!gLCapabilities.isPBuffer());
                    macOSXCGLGraphicsConfiguration.setChosenCapabilities(gLCapabilities);
                    if (GLContext.DEBUG) {
                        System.err.println("CGL create fixedCaps: " + gLCapabilities);
                    }
                    if (gLCapabilities.isPBuffer() && (n4 = CGL.CGLSetPBuffer(l2, MacOSXCGLContext.this.drawable.getHandle(), 0, 0, 0)) != 0) {
                        throw new GLException("Error code " + n4 + " while attaching context to pbuffer");
                    }
                }
            }
            finally {
                CGL.CGLDestroyPixelFormat(l3);
            }
            return l2;
        }

        @Override
        public boolean destroy(long l) {
            return CGL.CGLDestroyContext(l) == 0;
        }

        @Override
        public boolean contextRealized(boolean bl) {
            return true;
        }

        @Override
        public boolean copyImpl(long l, int n) {
            CGL.CGLCopyContext(l, MacOSXCGLContext.this.contextHandle, n);
            return true;
        }

        @Override
        public boolean makeCurrent(long l) {
            int n = CGL.CGLLockContext(l);
            if (0 == n) {
                n = CGL.CGLSetCurrentContext(l);
                if (0 == n) {
                    return true;
                }
                if (GLContext.DEBUG) {
                    System.err.println("CGL: Could not make context current: err 0x" + Integer.toHexString(n) + ": " + this);
                }
            } else if (GLContext.DEBUG) {
                System.err.println("CGL: Could not lock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return false;
        }

        @Override
        public boolean release(long l) {
            block4: {
                try {
                    MacOSXCGLContext.this.gl.glFlush();
                }
                catch (GLException gLException) {
                    if (!GLContext.DEBUG) break block4;
                    System.err.println("MacOSXCGLContext.CGLImpl.release: INFO: glFlush() catched exception:");
                    gLException.printStackTrace();
                }
            }
            int n = CGL.CGLSetCurrentContext(0L);
            if (GLContext.DEBUG && 0 != n) {
                System.err.println("CGL: Could not release current context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            int n2 = CGL.CGLUnlockContext(l);
            if (GLContext.DEBUG && 0 != n2) {
                System.err.println("CGL: Could not unlock context: err 0x" + Integer.toHexString(n2) + ": " + this);
            }
            return 0 == n && 0 == n2;
        }

        @Override
        public boolean detachPBuffer() {
            return true;
        }

        @Override
        public boolean setSwapInterval(int n) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
            intBuffer.put(0, n);
            CGL.CGLSetParameter(MacOSXCGLContext.this.contextHandle, 222, intBuffer);
            return true;
        }

        @Override
        public boolean swapBuffers() {
            return 0 == CGL.CGLFlushDrawable(MacOSXCGLContext.this.contextHandle);
        }
    }

    class NSOpenGLImpl
    implements GLBackendImpl {
        private OffscreenLayerSurface backingLayerHost = null;
        private long nsOpenGLLayer = 0L;
        private long nsOpenGLLayerPFmt = 0L;
        private float screenVSyncTimeout;
        private int vsyncTimeout;
        private int lastWidth = 0;
        private int lastHeight = 0;
        private boolean needsSetContextPBuffer = false;
        private ShaderProgram gl3ShaderProgram = null;
        private int skipSync = 0;

        NSOpenGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return true;
        }

        @Override
        public void drawableChangedNotify() {
            this.backingLayerHost = NativeWindowFactory.getOffscreenLayerSurface(MacOSXCGLContext.this.drawable.getNativeSurface(), true);
            if (null == this.backingLayerHost) {
                boolean[] blArray = new boolean[]{false};
                boolean[] blArray2 = new boolean[]{false};
                CGL.setContextView(MacOSXCGLContext.this.contextHandle, this.getNSViewHandle(blArray, blArray2));
            } else {
                this.nsOpenGLLayer = this.backingLayerHost.getAttachedSurfaceLayer();
            }
        }

        private long getNSViewHandle(boolean[] blArray, boolean[] blArray2) {
            long l;
            if (MacOSXCGLContext.this.drawable instanceof GLFBODrawableImpl) {
                l = 0L;
                blArray[0] = false;
                blArray2[0] = true;
                if (GLContext.DEBUG) {
                    System.err.println("NS create GLFBODrawableImpl drawable: isFBO " + blArray2 + ", isPBuffer " + blArray + ", " + MacOSXCGLContext.this.drawable.getClass().getName() + ",\n\t" + MacOSXCGLContext.this.drawable);
                }
            } else if (MacOSXCGLContext.this.drawable instanceof MacOSXCGLDrawable) {
                l = ((MacOSXCGLDrawable)MacOSXCGLContext.this.drawable).getNSViewHandle();
                blArray[0] = CGL.isNSOpenGLPixelBuffer(MacOSXCGLContext.this.drawable.getHandle());
                blArray2[0] = false;
                if (GLContext.DEBUG) {
                    System.err.println("NS create MacOSXCGLDrawable drawable handle isFBO " + blArray2 + ", isPBuffer " + blArray + ", " + MacOSXCGLContext.this.drawable.getClass().getName() + ",\n\t" + MacOSXCGLContext.this.drawable);
                }
            } else {
                long l2 = MacOSXCGLContext.this.drawable.getHandle();
                boolean bl = OSXUtil.isNSView(l2);
                boolean bl2 = OSXUtil.isNSWindow(l2);
                blArray[0] = CGL.isNSOpenGLPixelBuffer(l2);
                blArray2[0] = false;
                if (GLContext.DEBUG) {
                    System.err.println("NS create Anonymous drawable handle " + MacOSXCGLContext.toHexString(l2) + ": isNSView " + bl + ", isNSWindow " + bl2 + ", isFBO " + blArray2 + ", isPBuffer " + blArray + ", " + MacOSXCGLContext.this.drawable.getClass().getName() + ",\n\t" + MacOSXCGLContext.this.drawable);
                }
                if (bl) {
                    l = l2;
                } else if (bl2) {
                    l = OSXUtil.GetNSView(l2);
                } else if (blArray[0]) {
                    l = 0L;
                } else {
                    throw new RuntimeException("Anonymous drawable instance's handle neither NSView, NSWindow nor PBuffer: " + MacOSXCGLContext.toHexString(l2) + ", " + MacOSXCGLContext.this.drawable.getClass().getName() + ",\n\t" + MacOSXCGLContext.this.drawable);
                }
            }
            this.needsSetContextPBuffer = blArray[0];
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long create(long l, int n, int n2, int n3) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable;
            long l2;
            boolean bl;
            long l3 = 0L;
            NativeSurface nativeSurface = MacOSXCGLContext.this.drawable.getNativeSurface();
            MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable2 = (GLCapabilitiesImmutable)macOSXCGLGraphicsConfiguration.getChosenCapabilities();
            boolean[] blArray = new boolean[]{false};
            boolean[] blArray2 = new boolean[]{false};
            long l4 = this.getNSViewHandle(blArray, blArray2);
            boolean bl2 = blArray[0];
            boolean bl3 = blArray2[0];
            this.backingLayerHost = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true);
            boolean bl4 = bl = null != this.backingLayerHost;
            if (!bl && nativeSurface instanceof ProxySurface) {
                bl = ((ProxySurface)nativeSurface).containsUpstreamOptionBits(256);
            }
            if ((l2 = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSPixelFormat(gLCapabilitiesImmutable = bl3 ? new GLCapabilities(gLCapabilitiesImmutable2.getGLProfile()) : gLCapabilitiesImmutable2, n, n2, n3)) == 0L) {
                if (GLContext.DEBUG) {
                    System.err.println("Unable to allocate pixel format with requested GLCapabilities: " + gLCapabilitiesImmutable2);
                }
                return 0L;
            }
            if (bl3) {
                gLCapabilitiesImmutable = gLCapabilitiesImmutable2;
            } else {
                GLCapabilities gLCapabilities = MacOSXCGLGraphicsConfiguration.NSPixelFormat2GLCapabilities(gLCapabilitiesImmutable2.getGLProfile(), l2);
                if (!gLCapabilities.isPBuffer() && bl2) {
                    throw new InternalError("handle is PBuffer, fixedCaps not: " + MacOSXCGLContext.this.drawable);
                }
                gLCapabilities.setPBuffer(bl2);
                gLCapabilities.setBitmap(false);
                gLCapabilities.setOnscreen(!bl3 && !bl2);
                gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(gLCapabilities, gLCapabilitiesImmutable2.isBackgroundOpaque());
            }
            int n4 = OSXUtil.GetScreenRefreshRate(MacOSXCGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getIndex());
            this.screenVSyncTimeout = 1000000.0f / (float)n4;
            if (GLContext.DEBUG) {
                System.err.println("NS create OSX>=lion " + isLionOrLater);
                System.err.println("NS create incompleteView: " + bl);
                System.err.println("NS create backingLayerHost: " + this.backingLayerHost);
                System.err.println("NS create share: " + l);
                System.err.println("NS create drawable type: " + MacOSXCGLContext.this.drawable.getClass().getName());
                System.err.println("NS create drawable handle: isPBuffer " + bl2 + ", isFBO " + bl3);
                System.err.println("NS create pixelFormat: " + MacOSXCGLContext.toHexString(l2));
                System.err.println("NS create chosenCaps: " + gLCapabilitiesImmutable2);
                System.err.println("NS create fixedCaps: " + gLCapabilitiesImmutable);
                System.err.println("NS create drawable native-handle: " + MacOSXCGLContext.toHexString(MacOSXCGLContext.this.drawable.getHandle()));
                System.err.println("NS create drawable NSView-handle: " + MacOSXCGLContext.toHexString(l4));
                System.err.println("NS create screen refresh-rate: " + n4 + " hz, " + this.screenVSyncTimeout + " micros");
            }
            macOSXCGLGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable);
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
                l3 = CGL.createContext(l, l4, bl, l2, gLCapabilitiesImmutable2.isBackgroundOpaque(), intBuffer);
                if (0L == l3) {
                    if (GLContext.DEBUG) {
                        System.err.println("NS create failed: viewNotReady: " + (1 == intBuffer.get(0)));
                    }
                    long l5 = 0L;
                    return l5;
                }
                if (null != this.backingLayerHost) {
                    this.nsOpenGLLayerPFmt = l2;
                    l2 = 0L;
                }
                if (gLCapabilitiesImmutable2.isOnscreen() && !gLCapabilitiesImmutable2.isBackgroundOpaque()) {
                    CGL.setContextOpacity(l3, 0);
                }
            }
            finally {
                if (0L != l2) {
                    CGL.deletePixelFormat(l2);
                    l2 = 0L;
                }
            }
            return l3;
        }

        @Override
        public boolean destroy(long l) {
            return CGL.deleteContext(l, true);
        }

        @Override
        public boolean contextRealized(boolean bl) {
            if (bl) {
                if (null != this.backingLayerHost) {
                    int n;
                    long l;
                    int n2;
                    GLCapabilitiesImmutable gLCapabilitiesImmutable = MacOSXCGLContext.this.drawable.getChosenGLCapabilities();
                    long l2 = MacOSXCGLContext.this.getHandle();
                    long l3 = MacOSXCGLContext.this.drawable.getHandle();
                    if (MacOSXCGLContext.this.drawable instanceof GLFBODrawableImpl) {
                        GLFBODrawableImpl gLFBODrawableImpl = (GLFBODrawableImpl)MacOSXCGLContext.this.drawable;
                        n2 = gLFBODrawableImpl.getTextureBuffer(1028).getName();
                        l = 0L;
                        gLFBODrawableImpl.setSwapBufferContext(new GLFBODrawableImpl.SwapBufferContext(){

                            @Override
                            public void swapBuffers(boolean bl) {
                                NSOpenGLImpl.this.swapBuffers();
                            }
                        });
                    } else if (CGL.isNSOpenGLPixelBuffer(l3)) {
                        n2 = 0;
                        l = l3;
                        if (0L != l3) {
                            CGL.setContextPBuffer(l2, l);
                            this.needsSetContextPBuffer = false;
                        }
                    } else {
                        throw new GLException("BackingLayerHost w/ unknown handle (!FBO, !PBuffer): " + MacOSXCGLContext.this.drawable);
                    }
                    this.lastWidth = MacOSXCGLContext.this.drawable.getWidth();
                    this.lastHeight = MacOSXCGLContext.this.drawable.getHeight();
                    if (0 >= this.lastWidth || 0 >= this.lastHeight || !MacOSXCGLContext.this.drawable.isRealized()) {
                        throw new GLException("Drawable not realized yet or invalid texture size, texSize " + this.lastWidth + "x" + this.lastHeight + ", " + MacOSXCGLContext.this.drawable);
                    }
                    if (MacOSXCGLContext.this.isGL3core()) {
                        if (null == this.gl3ShaderProgram) {
                            this.gl3ShaderProgram = MacOSXCGLContext.createCALayerShader(MacOSXCGLContext.this.gl.getGL3());
                        }
                        n = this.gl3ShaderProgram.program();
                    } else {
                        n = 0;
                    }
                    this.nsOpenGLLayer = CGL.createNSOpenGLLayer(l2, n, this.nsOpenGLLayerPFmt, l, n2, gLCapabilitiesImmutable.isBackgroundOpaque(), this.lastWidth, this.lastHeight);
                    this.nsOpenGLLayerPFmt = 0L;
                    if (GLContext.DEBUG) {
                        System.err.println("NS create nsOpenGLLayer " + MacOSXCGLContext.toHexString(this.nsOpenGLLayer) + " w/ pbuffer " + MacOSXCGLContext.toHexString(l) + ", texID " + n2 + ", texSize " + this.lastWidth + "x" + this.lastHeight + ", " + MacOSXCGLContext.this.drawable);
                    }
                    this.backingLayerHost.attachSurfaceLayer(this.nsOpenGLLayer);
                    this.setSwapInterval(1);
                } else {
                    this.lastWidth = MacOSXCGLContext.this.drawable.getWidth();
                    this.lastHeight = MacOSXCGLContext.this.drawable.getHeight();
                }
            } else if (0L != this.nsOpenGLLayer) {
                OffscreenLayerSurface offscreenLayerSurface;
                NativeSurface nativeSurface = MacOSXCGLContext.this.drawable.getNativeSurface();
                if (GLContext.DEBUG) {
                    System.err.println("NS destroy nsOpenGLLayer " + MacOSXCGLContext.toHexString(this.nsOpenGLLayer) + ", " + MacOSXCGLContext.this.drawable);
                }
                if (null != (offscreenLayerSurface = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true)) && offscreenLayerSurface.isSurfaceLayerAttached()) {
                    offscreenLayerSurface.detachSurfaceLayer();
                }
                CGL.releaseNSOpenGLLayer(this.nsOpenGLLayer);
                if (null != this.gl3ShaderProgram) {
                    this.gl3ShaderProgram.destroy(MacOSXCGLContext.this.gl.getGL3());
                    this.gl3ShaderProgram = null;
                }
                this.nsOpenGLLayer = 0L;
            }
            this.backingLayerHost = null;
            return true;
        }

        private final void validatePBufferConfig(long l) {
            long l2 = MacOSXCGLContext.this.drawable.getHandle();
            if (this.needsSetContextPBuffer && 0L != l2 && CGL.isNSOpenGLPixelBuffer(l2)) {
                this.needsSetContextPBuffer = false;
                CGL.setContextPBuffer(l, l2);
                if (GLContext.DEBUG) {
                    System.err.println("NS.validateDrawableConfig bind pbuffer " + MacOSXCGLContext.toHexString(l2) + " -> ctx " + MacOSXCGLContext.toHexString(l));
                }
            }
        }

        private final boolean validateDrawableSizeConfig(long l) {
            int n = MacOSXCGLContext.this.drawable.getWidth();
            int n2 = MacOSXCGLContext.this.drawable.getHeight();
            if (this.lastWidth != n || this.lastHeight != n2) {
                this.lastWidth = MacOSXCGLContext.this.drawable.getWidth();
                this.lastHeight = MacOSXCGLContext.this.drawable.getHeight();
                if (GLContext.DEBUG) {
                    System.err.println("NS.validateDrawableConfig size changed");
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean copyImpl(long l, int n) {
            CGL.copyContext(MacOSXCGLContext.this.contextHandle, l, n);
            return true;
        }

        @Override
        public boolean makeCurrent(long l) {
            long l2 = CGL.getCGLContext(l);
            if (0L == l2) {
                throw new InternalError("Null CGLContext for: " + this);
            }
            int n = CGL.CGLLockContext(l2);
            if (0 == n) {
                this.validatePBufferConfig(l);
                return CGL.makeCurrentContext(l);
            }
            if (GLContext.DEBUG) {
                System.err.println("NSGL: Could not lock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return false;
        }

        @Override
        public boolean release(long l) {
            block4: {
                try {
                    MacOSXCGLContext.this.gl.glFlush();
                }
                catch (GLException gLException) {
                    if (!GLContext.DEBUG) break block4;
                    System.err.println("MacOSXCGLContext.NSOpenGLImpl.release: INFO: glFlush() catched exception:");
                    gLException.printStackTrace();
                }
            }
            boolean bl = CGL.clearCurrentContext(l);
            long l2 = CGL.getCGLContext(l);
            if (0L == l2) {
                throw new InternalError("Null CGLContext for: " + this);
            }
            int n = CGL.CGLUnlockContext(l2);
            if (GLContext.DEBUG && 0 != n) {
                System.err.println("CGL: Could not unlock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return bl && 0 == n;
        }

        @Override
        public boolean detachPBuffer() {
            this.needsSetContextPBuffer = true;
            return true;
        }

        @Override
        public boolean setSwapInterval(int n) {
            if (0L != this.nsOpenGLLayer) {
                CGL.setNSOpenGLLayerSwapInterval(this.nsOpenGLLayer, n);
                this.vsyncTimeout = n * (int)this.screenVSyncTimeout + 1000;
                if (GLContext.DEBUG) {
                    System.err.println("NS setSwapInterval: " + this.vsyncTimeout + " micros");
                }
            }
            CGL.setSwapInterval(MacOSXCGLContext.this.contextHandle, n);
            return true;
        }

        @Override
        public boolean swapBuffers() {
            boolean bl;
            if (0L != this.nsOpenGLLayer) {
                boolean bl2;
                int n;
                boolean bl3;
                if (this.validateDrawableSizeConfig(MacOSXCGLContext.this.contextHandle)) {
                    this.skipSync = 10;
                }
                if (bl3 = MacOSXCGLContext.this.drawable instanceof GLFBODrawableImpl) {
                    n = ((GLFBODrawableImpl)MacOSXCGLContext.this.drawable).getTextureBuffer(1028).getName();
                    bl2 = 0 != n;
                } else {
                    n = 0;
                    boolean bl4 = bl2 = 0L != MacOSXCGLContext.this.drawable.getHandle();
                }
                if (bl2) {
                    if (0 == this.skipSync) {
                        CGL.waitUntilNSOpenGLLayerIsReady(this.nsOpenGLLayer, this.vsyncTimeout);
                    } else {
                        --this.skipSync;
                    }
                    bl = CGL.flushBuffer(MacOSXCGLContext.this.contextHandle);
                    if (bl) {
                        if (bl3) {
                            CGL.setNSOpenGLLayerNeedsDisplayFBO(this.nsOpenGLLayer, n);
                        } else {
                            CGL.setNSOpenGLLayerNeedsDisplayPBuffer(this.nsOpenGLLayer, MacOSXCGLContext.this.drawable.getHandle());
                        }
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = CGL.flushBuffer(MacOSXCGLContext.this.contextHandle);
            }
            return bl;
        }
    }

    protected static interface GLBackendImpl {
        public boolean isNSContext();

        public void drawableChangedNotify();

        public long create(long var1, int var3, int var4, int var5);

        public boolean destroy(long var1);

        public boolean contextRealized(boolean var1);

        public boolean copyImpl(long var1, int var3);

        public boolean makeCurrent(long var1);

        public boolean release(long var1);

        public boolean detachPBuffer();

        public boolean setSwapInterval(int var1);

        public boolean swapBuffers();
    }
}

