/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.serial.Serial;

public class TempHumidSensor
extends PApplet {
    PImage a;
    PFont font22;
    PFont font44;
    PFont font48;
    PFont font12;
    float tempC;
    float tempF;
    float RH;
    float h;
    float MS_Byte;
    float LS_Byte;
    Serial Dev_Board;
    PrintWriter output;
    int[] PC_Time = new int[3];
    int[] MM_DD_YY = new int[3];
    int i;
    int j;
    int xx = -15;
    String curr_time;
    String X_Time;
    String curr_date;
    String filename;
    int rectX;
    int rectY;
    int rectSize = 90;
    int rectColor;
    int baseColor;
    int rectHighlight;
    int currentColor;
    boolean rectOver = false;
    boolean data_logg = false;
    char[] data = new char[15];
    char[] temp;
    char[] humid;
    int dataLength = 12;
    int TRAILER_OFFSET = 11;
    ADbutton button;

    public void renderUiInstance(int n, int n2, float f, float f2, boolean bl) {
        this.smooth();
        this.stroke(0);
        this.strokeWeight(2.0f);
        if (!bl) {
            this.fill(200.0f, 0.0f, 0.0f);
            this.ellipse(100 + n, 280 + n2, 58.0f, 50.0f);
            this.noStroke();
            this.fill(0.0f, 0.0f, 102.0f);
            this.arc(100 + n, 60 + n2, 30.0f, 20.0f, (float)Math.PI, (float)Math.PI * 2);
            this.rect(85 + n, 60 + n2, 30.0f, 200.0f);
            this.fill(250.0f, 250.0f, 250.0f);
            this.rect(95 + n, 60 + n2, 10.0f, 200.0f);
            this.stroke(0);
            this.strokeWeight(1.0f);
            this.textAlign(39);
            this.fill(0.0f, 46.0f, 250.0f);
            int n3 = 0;
            while (n3 < 5) {
                this.line(70 + n, 230 - 40 * n3 + n2, 80 + n, 230 - 40 * n3 + n2);
                if (n3 < 4) {
                    this.line(75 + n, 210 - 40 * n3 + n2, 80 + n, 210 - 40 * n3 + n2);
                }
                this.textFont(this.font12);
                this.text(TempHumidSensor.str((int)(40 + 20 * n3)), 65 + n, 235 - 40 * n3 + n2);
                ++n3;
            }
            this.image(this.a, 155 + n, 130 + n2);
            this.textAlign(37);
            n3 = 0;
            while (n3 < 6) {
                this.line(118 + n, 242 - 35 * n3 + n2, 128 + n, 242 - 35 * n3 + n2);
                if (n3 < 5) {
                    this.line(118 + n, 225 - 35 * n3 + n2, 123 + n, 225 - 35 * n3 + n2);
                }
                this.textFont(this.font12);
                this.text(TempHumidSensor.str((int)(0 + 10 * n3)), 135 + n, 247 - 35 * n3 + n2);
                ++n3;
            }
            this.noStroke();
            this.fill(0.0f, 46.0f, 250.0f);
            this.textFont(this.font22);
            this.textAlign(37);
            this.text("F", 57 + n, 46 + n2);
            this.text("C", 135 + n, 46 + n2);
            this.textFont(this.font12);
            this.text("o", 45 + n, 35 + n2);
            this.text("o", 125 + n, 35 + n2);
        }
        this.noStroke();
        this.fill(235.0f, 235.0f, 235.0f);
        this.rect(200 + n, 12 + n2, 190.0f, 100.0f);
        this.rect(240 + n, 108 + n2, 150.0f, 100.0f);
        this.fill(0.0f, 102.0f, 153.0f);
        this.textFont(this.font22);
        this.text("o", 310 + this.xx + n, 75 + n2);
        this.fill(0.0f, 102.0f, 153.0f);
        this.tempC = f2;
        this.RH = f;
        this.tempF = this.tempC * 9.0f / 5.0f + 32.0f;
        this.textFont(this.font44);
        this.text(TempHumidSensor.nfc((float)this.tempC, (int)2), 220 + this.xx + n, 90 + n2);
        this.text("C", 330 + this.xx + n, 90 + n2);
        this.textFont(this.font48);
        this.text(TempHumidSensor.nfc((float)this.RH, (int)2), 245 + n, 190 + n2);
        this.textFont(this.font22);
        this.text("%", 355 + n, 190 + n2);
        this.fill(255.0f, 255.0f, 255.0f);
        this.rect(95 + n, 246.0f, 10.0f, -187.0f);
        this.fill(200.0f, 0.0f, 0.0f);
        float f3 = -2.0f * this.tempF + 310.0f;
        this.h = 270.0f - f3;
        this.rect(95 + n, f3 + (float)n2, 10.0f, this.h);
        this.curr_time = this.PC_Time();
        this.curr_date = this.PC_Date();
        this.noFill();
        this.stroke(153);
        this.rect(10 + n, n2 + 10, 380.0f, 330.0f);
    }

    public void setup() {
        this.size(1200, 400);
        this.font22 = this.loadFont("MicrosoftYaHei-22.vlw");
        this.font12 = this.loadFont("MicrosoftYaHei-12.vlw");
        this.font44 = this.loadFont("FranklinGothic-Demi-32.vlw");
        this.font48 = this.loadFont("GillSansMT-48.vlw");
        try {
            this.Dev_Board = new Serial((PApplet)this, Serial.list()[1], 115200);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.smooth();
        this.rectColor = this.color(0, 90, 140);
        this.rectHighlight = this.color(80);
        this.rectX = 220;
        this.rectY = 250;
        this.ellipseMode(3);
        this.a = this.loadImage("waterdrop.jpg");
        this.background(235.0f, 235.0f, 235.0f);
        this.fill(200.0f, 6.0f, 0.0f);
        this.renderUiInstance(0, 0, 0.0f, 0.0f, false);
        this.renderUiInstance(400, 0, 0.0f, 0.0f, false);
        this.renderUiInstance(800, 0, 0.0f, 0.0f, false);
        this.button = new ADbutton(1030, 350, 150, 30, 10, "Start Log");
        this.textFont(this.font12);
        this.fill(0.0f, 46.0f, 0.0f);
        this.text("Developed by sachins@hobbyist.co.nz", 10.0f, 380.0f);
        this.frame.setTitle("CRL Temp & Humidity sensor");
    }

    public void draw() {
        this.delay(50);
        while (this.Dev_Board.available() > 0) {
            if (this.Dev_Board.read() != 35) continue;
            int n = 0;
            TempHumidSensor.println((String)"Start of data");
            while (n < this.dataLength && this.Dev_Board.available() > 0) {
                this.data[n] = 46;
                this.data[n++] = (char)(0xFF & this.Dev_Board.read());
            }
            if (this.data[this.TRAILER_OFFSET] != '%') {
                TempHumidSensor.print((String)("Bad frame, " + this.data[this.TRAILER_OFFSET] + " skipping!\n"));
                break;
            }
            int n2 = 0;
            while (n2 < this.dataLength) {
                TempHumidSensor.print((char)this.data[n2]);
                ++n2;
            }
            String string = new String(this.data);
            TempHumidSensor.println((String)("Temp:" + Float.parseFloat(string.substring(1, 6))));
            TempHumidSensor.println((String)("Humidity:" + Float.parseFloat(string.substring(6, 11))));
            float f = Float.parseFloat(string.substring(1, 6));
            float f2 = Float.parseFloat(string.substring(6, 11));
            int n3 = Integer.parseInt(string.substring(0, 1));
            this.renderUiInstance(n3 * 400, 0, f2, f, false);
            this.writeLog(n3, f, f2);
        }
        this.button.update();
    }

    public void writeLog(int n, float f, float f2) {
        if (this.data_logg) {
            this.curr_date = this.PC_Date();
            this.curr_time = this.PC_Time();
            String string = String.valueOf(this.curr_date) + " " + this.curr_time + "," + n + "," + TempHumidSensor.nfc((float)f, (int)2) + "," + TempHumidSensor.nfc((float)f2, (int)2);
            this.output.println(string);
        }
    }

    public void mousePressed() {
        if (this.button.update()) {
            boolean bl = this.button.pressed = !this.button.pressed;
            if (this.button.pressed) {
                this.button.setLabel("Stop Log");
                this.data_logg = true;
                this.curr_date = this.PC_Date();
                this.curr_time = this.PC_Time();
                String[] stringArray = TempHumidSensor.split((String)this.curr_date, (String)"  ");
                this.filename = "DataLogger_" + TempHumidSensor.join((String[])stringArray, (String)"");
                stringArray = TempHumidSensor.split((String)this.curr_time, (String)"  ");
                this.filename = String.valueOf(this.filename) + TempHumidSensor.join((String[])stringArray, (String)"") + ".csv";
                this.output = this.createWriter(this.filename);
                this.output.println("MM-DD-YYYY HH-MM-SS,Sensor ID,Temp degC,Relative Humidity%");
            } else {
                this.button.setLabel("Start Log");
                if (this.data_logg) {
                    this.data_logg = false;
                    this.output.flush();
                    this.output.close();
                }
            }
        }
    }

    public boolean overRect(int n, int n2, int n3, int n4) {
        return this.mouseX >= n && this.mouseX <= n + n3 && this.mouseY >= n2 && this.mouseY <= n2 + n4;
    }

    public String PC_Time() {
        String[] stringArray = new String[3];
        this.PC_Time[2] = TempHumidSensor.second();
        this.PC_Time[1] = TempHumidSensor.minute();
        this.PC_Time[0] = TempHumidSensor.hour();
        String string = TempHumidSensor.nf((int)TempHumidSensor.second(), (int)2);
        String string2 = TempHumidSensor.nf((int)TempHumidSensor.minute(), (int)2);
        String string3 = TempHumidSensor.nf((int)TempHumidSensor.hour(), (int)2);
        stringArray[2] = string;
        stringArray[1] = string2;
        stringArray[0] = string3;
        return TempHumidSensor.join((String[])stringArray, (String)"-");
    }

    public String PC_Date() {
        this.MM_DD_YY[2] = TempHumidSensor.year();
        this.MM_DD_YY[1] = TempHumidSensor.day();
        this.MM_DD_YY[0] = TempHumidSensor.month();
        return TempHumidSensor.join((String[])TempHumidSensor.nf((int[])this.MM_DD_YY, (int)2), (String)"-");
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"TempHumidSensor"};
        if (stringArray != null) {
            PApplet.main((String[])TempHumidSensor.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class ADbutton {
        int lightColorButton = -855310;
        int darkColorButton = -11513776;
        int innerRectButton = -4737097;
        int innerRectButtonLight = -3750202;
        int fontColorEnabled = 255;
        int fontColorDisabled = -6908266;
        int fontSize = 18;
        boolean visible = true;
        boolean enabled = true;
        final int mouseNotOver = 0;
        final int mouseOver = 1;
        final int mouseClick = 2;
        boolean mouseButtonPressed = false;
        String buttonLabel;
        int buttonX;
        int buttonY;
        int buttonW;
        int buttonH;
        int buttonR;
        int buttonAx;
        int buttonAy;
        int buttonHr;
        float startTime;
        boolean didEnter;
        boolean firstTime = true;
        int buttonHelpTime = 1500;
        int buttonHelpSize = 12;
        int buttonHelpColor = 0;
        String buttonHelpText = "";
        boolean buttonHelp = false;
        boolean debug = false;
        boolean pressed = false;

        ADbutton(int n, int n2, int n3, int n4, int n5, String string) {
            this.buttonX = n;
            this.buttonY = n2;
            this.buttonW = n3;
            this.buttonH = n4;
            this.buttonR = n5;
            this.buttonAx = this.buttonX + this.buttonW - 1;
            this.buttonAy = this.buttonY + this.buttonH - 1;
            this.buttonHr = this.buttonR / 2;
            this.buttonLabel = string;
        }

        public void display(int n) {
            if (this.visible) {
                TempHumidSensor.this.noStroke();
                TempHumidSensor.this.rectMode(0);
                switch (n) {
                    case 0: {
                        TempHumidSensor.this.fill(this.innerRectButton);
                        break;
                    }
                    case 1: {
                        if (this.enabled) {
                            TempHumidSensor.this.fill(this.innerRectButtonLight);
                            break;
                        }
                        TempHumidSensor.this.fill(this.innerRectButton);
                        break;
                    }
                    case 2: {
                        TempHumidSensor.this.fill(this.innerRectButtonLight);
                    }
                }
                TempHumidSensor.this.pushMatrix();
                TempHumidSensor.this.translate(0.0f, 0.0f);
                TempHumidSensor.this.rect(this.buttonX, this.buttonY, this.buttonW, this.buttonH);
                TempHumidSensor.this.textAlign(3);
                TempHumidSensor.this.textSize(this.fontSize);
                switch (n) {
                    case 0: {
                        TempHumidSensor.this.fill(-7105645);
                        TempHumidSensor.this.text(this.buttonLabel, this.buttonX + this.buttonW / 2 + 1, this.buttonY + this.buttonH / 2 + 11 - 5 + 1);
                        if (this.enabled) {
                            TempHumidSensor.this.fill(this.fontColorEnabled);
                        } else {
                            TempHumidSensor.this.fill(this.fontColorDisabled);
                        }
                        TempHumidSensor.this.text(this.buttonLabel, this.buttonX + this.buttonW / 2, this.buttonY + this.buttonH / 2 + 11 - 5);
                        TempHumidSensor.this.fill(this.lightColorButton);
                        break;
                    }
                    case 1: {
                        TempHumidSensor.this.fill(-7105645);
                        TempHumidSensor.this.text(this.buttonLabel, this.buttonX + this.buttonW / 2 + 1, this.buttonY + this.buttonH / 2 + 11 - 5 + 1);
                        if (this.enabled) {
                            TempHumidSensor.this.fill(this.fontColorEnabled);
                        } else {
                            TempHumidSensor.this.fill(this.fontColorDisabled);
                        }
                        TempHumidSensor.this.text(this.buttonLabel, this.buttonX + this.buttonW / 2, this.buttonY + this.buttonH / 2 + 11 - 5);
                        TempHumidSensor.this.fill(this.lightColorButton);
                        break;
                    }
                    case 2: {
                        TempHumidSensor.this.fill(-7105645);
                        TempHumidSensor.this.text(this.buttonLabel, this.buttonX + this.buttonW / 2 + 3 + 1, this.buttonY + this.buttonH / 2 + 11 - 2 + 1);
                        if (this.enabled) {
                            TempHumidSensor.this.fill(this.fontColorEnabled);
                        } else {
                            TempHumidSensor.this.fill(this.fontColorDisabled);
                        }
                        TempHumidSensor.this.text(this.buttonLabel, this.buttonX + this.buttonW / 2 + 3, this.buttonY + this.buttonH / 2 + 11 - 2);
                        TempHumidSensor.this.fill(this.darkColorButton);
                    }
                }
                TempHumidSensor.this.arc(this.buttonX, this.buttonY, this.buttonR, this.buttonR, TempHumidSensor.radians((float)180.0f), TempHumidSensor.radians((float)270.0f));
                TempHumidSensor.this.arc(this.buttonAx, this.buttonY, this.buttonR, this.buttonR, TempHumidSensor.radians((float)270.0f), TempHumidSensor.radians((float)315.0f));
                TempHumidSensor.this.arc(this.buttonX, this.buttonAy, this.buttonR, this.buttonR, TempHumidSensor.radians((float)135.0f), TempHumidSensor.radians((float)180.0f));
                TempHumidSensor.this.rect(this.buttonX, this.buttonY - this.buttonHr, this.buttonW, this.buttonHr);
                TempHumidSensor.this.rect(this.buttonX - this.buttonHr, this.buttonY, this.buttonHr, this.buttonH);
                switch (n) {
                    case 0: {
                        TempHumidSensor.this.fill(this.darkColorButton);
                        break;
                    }
                    case 1: {
                        TempHumidSensor.this.fill(this.darkColorButton);
                        break;
                    }
                    case 2: {
                        TempHumidSensor.this.fill(this.lightColorButton);
                    }
                }
                TempHumidSensor.this.arc(this.buttonAx, this.buttonAy, this.buttonR, this.buttonR, TempHumidSensor.radians((float)0.0f), TempHumidSensor.radians((float)90.0f));
                TempHumidSensor.this.arc(this.buttonAx, this.buttonY, this.buttonR, this.buttonR, TempHumidSensor.radians((float)315.0f), TempHumidSensor.radians((float)360.0f));
                TempHumidSensor.this.arc(this.buttonX, this.buttonAy, this.buttonR, this.buttonR, TempHumidSensor.radians((float)90.0f), TempHumidSensor.radians((float)135.0f));
                TempHumidSensor.this.rect(this.buttonX, this.buttonY + this.buttonH, this.buttonW, this.buttonHr);
                TempHumidSensor.this.rect(this.buttonX + this.buttonW, this.buttonY, this.buttonHr, this.buttonH);
                TempHumidSensor.this.popMatrix();
            }
        }

        public void setHelpOn(String string) {
            this.buttonHelp = true;
            this.buttonHelpText = string;
        }

        public void setHelpTextOff() {
            this.buttonHelp = false;
        }

        public void showHelp() {
            TempHumidSensor.this.textSize(this.buttonHelpSize);
            TempHumidSensor.this.textAlign(37);
            if (TempHumidSensor.this.mouseY < this.buttonY + this.buttonH / 2) {
                TempHumidSensor.this.fill(-89);
                TempHumidSensor.this.strokeWeight(1.0f);
                TempHumidSensor.this.stroke(0);
                if (TempHumidSensor.this.mouseX > this.buttonX + this.buttonW / 2) {
                    TempHumidSensor.this.rect(TempHumidSensor.this.mouseX - 5, TempHumidSensor.this.mouseY - this.buttonH / 2 - 25, TempHumidSensor.this.textWidth(this.buttonHelpText) + 8.0f, 20.0f);
                    TempHumidSensor.this.fill(this.buttonHelpColor);
                    TempHumidSensor.this.text(this.buttonHelpText, TempHumidSensor.this.mouseX, TempHumidSensor.this.mouseY - this.buttonH / 2 - 10);
                } else {
                    TempHumidSensor.this.rect((float)TempHumidSensor.this.mouseX - TempHumidSensor.this.textWidth(this.buttonHelpText) - 5.0f, TempHumidSensor.this.mouseY - this.buttonH / 2 - 25, TempHumidSensor.this.textWidth(this.buttonHelpText) + 8.0f, 20.0f);
                    TempHumidSensor.this.fill(this.buttonHelpColor);
                    TempHumidSensor.this.text(this.buttonHelpText, (float)TempHumidSensor.this.mouseX - TempHumidSensor.this.textWidth(this.buttonHelpText), TempHumidSensor.this.mouseY - this.buttonH / 2 - 10);
                }
            } else {
                TempHumidSensor.this.fill(-89);
                TempHumidSensor.this.strokeWeight(1.0f);
                TempHumidSensor.this.stroke(0);
                if (TempHumidSensor.this.mouseX < this.buttonX + this.buttonW / 2) {
                    TempHumidSensor.this.rect((float)TempHumidSensor.this.mouseX - TempHumidSensor.this.textWidth(this.buttonHelpText) - 5.0f, TempHumidSensor.this.mouseY + this.buttonH / 2, TempHumidSensor.this.textWidth(this.buttonHelpText) + 8.0f, 20.0f);
                    TempHumidSensor.this.fill(this.buttonHelpColor);
                    TempHumidSensor.this.text(this.buttonHelpText, (float)TempHumidSensor.this.mouseX - TempHumidSensor.this.textWidth(this.buttonHelpText), TempHumidSensor.this.mouseY + this.buttonH / 2 + 15);
                } else {
                    TempHumidSensor.this.rect(TempHumidSensor.this.mouseX - 5, TempHumidSensor.this.mouseY + this.buttonH / 2, TempHumidSensor.this.textWidth(this.buttonHelpText) + 8.0f, 20.0f);
                    TempHumidSensor.this.fill(this.buttonHelpColor);
                    TempHumidSensor.this.text(this.buttonHelpText, TempHumidSensor.this.mouseX, TempHumidSensor.this.mouseY + this.buttonH / 2 + 15);
                }
            }
        }

        public void updatePosition() {
            this.buttonX = this.buttonX + TempHumidSensor.this.mouseX - TempHumidSensor.this.pmouseX;
            this.buttonY = this.buttonY + TempHumidSensor.this.mouseY - TempHumidSensor.this.pmouseY;
            this.buttonAx = this.buttonX + this.buttonW - 1;
            this.buttonAy = this.buttonY + this.buttonH - 1;
        }

        public void updatePosition(int n, int n2) {
            this.buttonX += n;
            this.buttonY += n2;
            this.buttonAx = this.buttonX + this.buttonW - 1;
            this.buttonAy = this.buttonY + this.buttonH - 1;
        }

        public boolean update() {
            if (!this.visible) {
                return false;
            }
            if (TempHumidSensor.this.mouseX > this.buttonX - this.buttonR / 2 && TempHumidSensor.this.mouseX < this.buttonX + this.buttonW + this.buttonR / 2 && TempHumidSensor.this.mouseY > this.buttonY - this.buttonR / 2 && TempHumidSensor.this.mouseY < this.buttonY + this.buttonH + this.buttonR / 2) {
                this.didEnter = true;
                if (TempHumidSensor.this.mousePressed && TempHumidSensor.this.mouseButton == 37) {
                    if (TempHumidSensor.this.keyPressed && this.debug) {
                        if (TempHumidSensor.this.keyCode == 17) {
                            this.updatePosition();
                            this.display(1);
                        }
                        if (TempHumidSensor.this.keyCode == 16) {
                            this.printGeometry();
                            this.display(1);
                        }
                    } else {
                        if (this.enabled) {
                            this.display(2);
                        } else {
                            this.display(0);
                        }
                        if (!this.mouseButtonPressed) {
                            if (this.enabled) {
                                this.mouseButtonPressed = true;
                                return true;
                            }
                            return false;
                        }
                    }
                } else {
                    this.display(1);
                    this.mouseButtonPressed = false;
                }
            } else {
                this.didEnter = false;
                this.firstTime = true;
                this.display(0);
            }
            if (this.didEnter) {
                if (this.firstTime) {
                    this.startTime = TempHumidSensor.this.millis();
                }
                this.firstTime = false;
                if ((float)TempHumidSensor.this.millis() - this.startTime > (float)this.buttonHelpTime && this.buttonHelp) {
                    this.showHelp();
                }
            }
            return false;
        }

        public void hide() {
            this.visible = false;
        }

        public void unhide() {
            this.visible = true;
        }

        public void setLabel(String string) {
            this.buttonLabel = string;
        }

        public String getLabel() {
            return this.buttonLabel;
        }

        public void setFontSize(int n) {
            this.fontSize = n;
        }

        public int getFontSize(int n) {
            return this.fontSize;
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }

        public boolean status() {
            return this.enabled;
        }

        public void setColor(int n) {
            this.innerRectButton = n;
            this.innerRectButtonLight = n + -15790321;
        }

        public void setDefaultColor() {
            this.innerRectButton = -4737097;
            this.innerRectButtonLight = this.innerRectButton + -15790321;
        }

        public void setDebugOn() {
            this.debug = true;
        }

        public void setDebugOff() {
            this.debug = false;
        }

        public void printGeometry() {
            TempHumidSensor.println((String)("button = new ADbutton(" + this.buttonX + ", " + this.buttonY + ", " + this.buttonW + ", " + this.buttonH + ", " + this.buttonR + ", \"" + this.buttonLabel + "\");"));
        }
    }
}

