/*
  SD card read/write and lcd test
 
 This example shows how to read and write data to and from an SD card file 	
 The circuit:
 * SD card attached to SPI bus as follows:
 ** MOSI - pin 11
 ** MISO - pin 12
 ** CLK - pin 13
 ** CS - pin 4
 
 adapted from code by David A. Mellis
and Tom Igoe
 
 This example code is in the public domain.
 	 
 */
#include<stdlib.h>          // for float-to-str
#include <SD.h>
#include <LiquidCrystal.h>
LiquidCrystal lcd(3, 4, 5, 6, 7, 8);	// leave pins 0,1 available for serial, and pin 2 available for interrupt

File myFile;
int countVal = 1;


void setup()
{
  Serial.begin(57600);
  lcd.begin(16, 2);
  // Print a message to the LCD.
  lcd.print("Initialising!");
  lcd.setCursor(0,1);
  lcd.print("Tests sd, lcd");
  delay(1000);	
  
  Serial.print("Initializing SD card...");
  // On the Shield, CS is pin 4. It's set as an output by default.
  // Note that even if it's not used as the CS pin, the hardware SS pin 
  // (10 on most Arduino boards, 53 on the Mega) must be left as an output 
  // or the SD library functions will not work. 
   pinMode(10, OUTPUT);
   lcd.setCursor(0,2);
  if (!SD.begin(10)) {
    Serial.println("initialization failed!");
    lcd.print("init. failed.");
    return;
  }
    
  Serial.println("initialization done.");
  lcd.print("init. done.");
  myFile = SD.open("t3.txt", FILE_WRITE);    // create file if not exist
  if (SD.exists("t3.txt"))
  {
   Serial.println(" t3 exists");
   lcd.print("file exists");
   //myFile = SD.open("t3.txt", FILE_WRITE);
   //Serial.println("t3 opened");
   //char initialString[] = "trackpoint, latitude, longitude, speed, heading";
   //myFile.println(initialString);
   //``myFile.close();   
  }

  

}

void loop()
{
  

    lcd.clear();
    lcd.setCursor(1,0);
    lcd.print("w: ");
    
char  s;
String sd;
//char buff[12];
  // re-open the file for reading:
  File myFile1 = SD.open("t3.txt");
  if (myFile1) {
    Serial.println("reading:");
    
    // read from the file until there's nothing else in it:
    while (myFile1.available()) {
       //s = atoi(myFile1.read());
       //s = buff;
       s = myFile1.read();
       sd += s;
    if (s!=10 && s!=13) {
        lcd.write(s);
    }
        delay(200);
    }
    // close the file:
    myFile1.close();
    Serial.println("done reading.");
    lcd.print("fin: ");
  } else {
  	// if the file didn't open, print an error:
    Serial.println("error opening t3.txt");
  }	
  delay(5000);
}


