#include <SoftwareSerial.h>

#include <TinyGPS.h>
#include <LiquidCrystal.h>

/* MOD of TinyGPS test.  Gets GPS data and displays on LCD

This sample code demonstrates the normal use of a TinyGPS object.
   It requires the use of SoftwareSerial, and assumes that you have a
   4800-baud serial GPS device hooked up on pins 3(rx) and 4(tx).
*/

TinyGPS gps;
SoftwareSerial ss(14, 15);
LiquidCrystal lcd(3, 4, 5, 6, 7, 8);	// leave pins 0,1 available for serial, and pin 2 available for interrupt


void setup()
{
  Serial.begin(57600);
  ss.begin(9600);
  lcd.begin(16, 2);
  // Print a message to the LCD.
  lcd.print("Initialising!");
  lcd.setCursor(0,1);
  lcd.print("Tests gps, lcd");
  delay(400);	
  
  Serial.print("Simple TinyGPS library v. "); //Serial.println(TinyGPS::library_version());
  Serial.println("by Mikal Hart");
  Serial.println();
}

void loop()
{
  //delay(3000);
  bool newData = false;
  unsigned long chars;
  unsigned short sentences, failed;

  // For one second we parse GPS data and report some key values
  for (unsigned long start = millis(); millis() - start < 1000;)
  {
    while (ss.available())
    //while (ss)
    {
      char c = ss.read();
       Serial.write(c); // uncomment this line if you want to see the GPS data flowing
      if (gps.encode(c)) // Did a new valid sentence come in?
      //if (c) // Did a new valid sentence come in?
        newData = true;
    }
  }
unsigned long age;
  if (newData)
  {
    float flat, flon;
    
    gps.f_get_position(&flat, &flon, &age);
    Serial.println("connected to satellite");
    Serial.print("LAT=");
    Serial.print(flat == TinyGPS::GPS_INVALID_F_ANGLE ? 0.0 : flat, 6);
    Serial.print(" LON=");
    Serial.print(flon == TinyGPS::GPS_INVALID_F_ANGLE ? 0.0 : flon, 6);
    Serial.print(" SAT=");
    Serial.print(gps.satellites() == TinyGPS::GPS_INVALID_SATELLITES ? 0 : gps.satellites());
    Serial.print(" PREC=");
    Serial.print(gps.hdop() == TinyGPS::GPS_INVALID_HDOP ? 0 : gps.hdop());
    Serial.print(" Fix age=");
    Serial.println(age == TinyGPS::GPS_INVALID_AGE ? 0 : age);
  }
  if (age>0 && age < 3000) 
  {
   // fix is valid
  Serial.print(" Valid Fix: ");
  Serial.print(age);
  Serial.println("Yay!");
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("Fix age: ");
  lcd.print(age);
  }
  else
  {
   // invalid fix
  lcd.clear();
  Serial.println(" cannot connect to satellite ");
  Serial.println("doh!");
  lcd.setCursor(0,0);
  lcd.print("No fix");
  }
  
  gps.stats(&chars, &sentences, &failed);
  
 
}
