/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.Chart3DChangeEvent;
import com.orsoncharts.Chart3DChangeListener;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DHints;
import com.orsoncharts.ChartBox3D;
import com.orsoncharts.ChartElement;
import com.orsoncharts.ChartElementVisitor;
import com.orsoncharts.OnDrawHandler;
import com.orsoncharts.TitleAnchor;
import com.orsoncharts.TitleUtils;
import com.orsoncharts.axis.Axis3D;
import com.orsoncharts.axis.TickData;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.ItemKey;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.DoubleSidedFace;
import com.orsoncharts.graphics3d.Drawable3D;
import com.orsoncharts.graphics3d.Face;
import com.orsoncharts.graphics3d.FaceSorter;
import com.orsoncharts.graphics3d.LabelFace;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.graphics3d.RenderedElement;
import com.orsoncharts.graphics3d.RenderingInfo;
import com.orsoncharts.graphics3d.StandardFaceSorter;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.interaction.InteractiveElementType;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.legend.LegendBuilder;
import com.orsoncharts.legend.StandardLegendBuilder;
import com.orsoncharts.marker.Marker;
import com.orsoncharts.marker.MarkerData;
import com.orsoncharts.plot.AbstractPlot3D;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.PiePlot3D;
import com.orsoncharts.plot.Plot3D;
import com.orsoncharts.plot.Plot3DChangeEvent;
import com.orsoncharts.plot.Plot3DChangeListener;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.style.ChartStyle;
import com.orsoncharts.style.ChartStyleChangeEvent;
import com.orsoncharts.style.ChartStyleChangeListener;
import com.orsoncharts.style.ChartStyler;
import com.orsoncharts.table.GridElement;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.RectanglePainter;
import com.orsoncharts.table.StandardRectanglePainter;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TextElement;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.Orientation;
import com.orsoncharts.util.RefPt2D;
import com.orsoncharts.util.TextAnchor;
import com.orsoncharts.util.TextUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;

public class Chart3D
implements Drawable3D,
ChartElement,
Plot3DChangeListener,
ChartStyleChangeListener,
Serializable {
    public static final double DEFAULT_PROJ_DIST = 1500.0;
    public static final String INTERACTIVE_ELEMENT_TYPE = "interactive_element_type";
    public static final String SERIES_KEY = "series_key";
    private String id;
    private RectanglePainter background;
    private TableElement title;
    private Anchor2D titleAnchor;
    private LegendBuilder legendBuilder;
    private Anchor2D legendAnchor;
    private Orientation legendOrientation;
    private Plot3D plot;
    private ViewPoint3D viewPoint;
    private double projDist;
    private Color chartBoxColor;
    private Offset2D translate2D;
    private transient EventListenerList listenerList;
    private boolean notify;
    private transient RenderingHints renderingHints;
    private ChartStyle style;
    private transient World world;
    private FaceSorter faceSorter;
    private boolean elementHinting;

    public Chart3D(String title, String subtitle, Plot3D plot) {
        this(title, subtitle, plot, Chart3DFactory.getDefaultChartStyle());
    }

    public Chart3D(String title, String subtitle, Plot3D plot, ChartStyle style) {
        ArgChecks.nullNotPermitted(plot, "plot");
        ArgChecks.nullNotPermitted(style, "style");
        plot.setChart(this);
        this.background = new StandardRectanglePainter(Color.WHITE);
        if (title != null) {
            this.title = TitleUtils.createTitle(title, subtitle);
        }
        this.titleAnchor = TitleAnchor.TOP_LEFT;
        this.legendBuilder = new StandardLegendBuilder();
        this.legendAnchor = LegendAnchor.BOTTOM_RIGHT;
        this.legendOrientation = Orientation.HORIZONTAL;
        this.plot = plot;
        this.plot.addChangeListener(this);
        Dimension3D dim = this.plot.getDimensions();
        float distance = (float)dim.getDiagonalLength() * 3.0f;
        this.viewPoint = ViewPoint3D.createAboveViewPoint(distance);
        this.projDist = 1500.0;
        this.chartBoxColor = new Color(255, 255, 255, 100);
        this.translate2D = new Offset2D();
        this.faceSorter = new StandardFaceSorter();
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.elementHinting = false;
        this.notify = true;
        this.listenerList = new EventListenerList();
        this.style = style;
        this.style.addChangeListener(this);
        this.receive(new ChartStyler(this.style));
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public RectanglePainter getBackground() {
        return this.background;
    }

    public void setBackground(RectanglePainter background) {
        this.background = background;
        this.fireChangeEvent();
    }

    public TableElement getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            this.setTitle((TableElement)null);
        } else {
            this.setTitle(title, this.style.getTitleFont(), TitleUtils.DEFAULT_TITLE_COLOR);
        }
    }

    public void setTitle(String title, Font font, Color color) {
        ArgChecks.nullNotPermitted(font, "font");
        ArgChecks.nullNotPermitted(color, "color");
        TextElement te = new TextElement(title);
        te.setTag("CHART_TITLE");
        te.setFont(font);
        te.setColor(color);
        this.setTitle(te);
    }

    public void setTitle(TableElement title) {
        this.title = title;
        this.fireChangeEvent();
    }

    public Anchor2D getTitleAnchor() {
        return this.titleAnchor;
    }

    public void setTitleAnchor(Anchor2D anchor) {
        ArgChecks.nullNotPermitted(anchor, "anchor");
        this.titleAnchor = anchor;
        this.fireChangeEvent();
    }

    public Plot3D getPlot() {
        return this.plot;
    }

    public Color getChartBoxColor() {
        return this.chartBoxColor;
    }

    public void setChartBoxColor(Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.chartBoxColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Dimension3D getDimensions() {
        return this.plot.getDimensions();
    }

    @Override
    public ViewPoint3D getViewPoint() {
        return this.viewPoint;
    }

    @Override
    public void setViewPoint(ViewPoint3D viewPoint) {
        ArgChecks.nullNotPermitted(viewPoint, "viewPoint");
        this.viewPoint = viewPoint;
        this.fireChangeEvent();
    }

    @Override
    public double getProjDistance() {
        return this.projDist;
    }

    @Override
    public void setProjDistance(double dist) {
        this.projDist = dist;
        this.fireChangeEvent();
    }

    @Override
    public Offset2D getTranslate2D() {
        return this.translate2D;
    }

    @Override
    public void setTranslate2D(Offset2D offset) {
        ArgChecks.nullNotPermitted(offset, "offset");
        this.translate2D = offset;
        this.fireChangeEvent();
    }

    public LegendBuilder getLegendBuilder() {
        return this.legendBuilder;
    }

    public void setLegendBuilder(LegendBuilder legendBuilder) {
        this.legendBuilder = legendBuilder;
        this.fireChangeEvent();
    }

    public Anchor2D getLegendAnchor() {
        return this.legendAnchor;
    }

    public void setLegendAnchor(Anchor2D anchor) {
        ArgChecks.nullNotPermitted(anchor, "anchor");
        this.legendAnchor = anchor;
        this.fireChangeEvent();
    }

    public Orientation getLegendOrientation() {
        return this.legendOrientation;
    }

    public void setLegendOrientation(Orientation orientation) {
        ArgChecks.nullNotPermitted((Object)orientation, "orientation");
        this.legendOrientation = orientation;
        this.fireChangeEvent();
    }

    public void setLegendPosition(Anchor2D anchor, Orientation orientation) {
        this.setNotify(false);
        this.setLegendAnchor(anchor);
        this.setLegendOrientation(orientation);
        this.setNotify(true);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints hints) {
        ArgChecks.nullNotPermitted(hints, "hints");
        this.renderingHints = hints;
        this.fireChangeEvent();
    }

    public boolean getAntiAlias() {
        Object val = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING);
        return RenderingHints.VALUE_ANTIALIAS_ON.equals(val);
    }

    public void setAntiAlias(boolean flag) {
        if (flag) {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.fireChangeEvent();
    }

    public boolean getElementHinting() {
        return this.elementHinting;
    }

    public void setElementHinting(boolean hinting) {
        this.elementHinting = hinting;
        this.fireChangeEvent();
    }

    public ChartStyle getStyle() {
        return this.style;
    }

    public void setStyle(ChartStyle style) {
        ArgChecks.nullNotPermitted(style, "style");
        this.style.removeChangeListener(this);
        this.style = style;
        this.style.addChangeListener(this);
        this.setNotify(false);
        this.receive(new ChartStyler(this.style));
        this.setNotify(true);
    }

    private World createWorld(ChartBox3D chartBox) {
        World result = new World();
        Dimension3D dim = this.plot.getDimensions();
        double w = dim.getWidth();
        double h = dim.getHeight();
        double d = dim.getDepth();
        if (chartBox != null) {
            result.add("chartbox", chartBox.createObject3D());
        }
        this.plot.compose(result, -w / 2.0, -h / 2.0, -d / 2.0);
        return result;
    }

    @Override
    public RenderingInfo draw(Graphics2D g2, Rectangle2D bounds) {
        TableElement legend;
        this.beginElement(g2, this.id, "ORSON_CHART_TOP_LEVEL");
        Shape savedClip = g2.getClip();
        g2.clip(bounds);
        g2.addRenderingHints(this.renderingHints);
        g2.setStroke(new BasicStroke(1.5f, 1, 1, 1.0f));
        Dimension3D dim3D = this.plot.getDimensions();
        double w = dim3D.getWidth();
        double h = dim3D.getHeight();
        double depth = dim3D.getDepth();
        ChartBox3D chartBox = null;
        if (this.plot instanceof XYZPlot || this.plot instanceof CategoryPlot3D) {
            double[] tickUnits = this.findAxisTickUnits(g2, w, h, depth);
            chartBox = new ChartBox3D(w, h, depth, -w / 2.0, -h / 2.0, -depth / 2.0, this.chartBoxColor);
            chartBox.setXTicks(this.fetchXTickData(this.plot, tickUnits[0]));
            chartBox.setYTicks(this.fetchYTickData(this.plot, tickUnits[1]));
            chartBox.setZTicks(this.fetchZTickData(this.plot, tickUnits[2]));
            chartBox.setXMarkers(this.fetchXMarkerData(this.plot));
            chartBox.setYMarkers(this.fetchYMarkerData(this.plot));
            chartBox.setZMarkers(this.fetchZMarkerData(this.plot));
        }
        if (this.world == null) {
            this.world = this.createWorld(chartBox);
        } else if (chartBox != null) {
            this.world.clear("chartbox");
            this.world.add("chartbox", chartBox.createObject3D());
        }
        if (this.background != null) {
            this.background.fill(g2, bounds);
        }
        AffineTransform saved = g2.getTransform();
        double dx = bounds.getWidth() / 2.0 + this.translate2D.getDX();
        double dy = bounds.getHeight() / 2.0 + this.translate2D.getDY();
        g2.translate(dx, dy);
        Point3D[] eyePts = this.world.calculateEyeCoordinates(this.viewPoint);
        Point2D[] pts = this.world.calculateProjectedPoints(this.viewPoint, this.projDist);
        List<Face> facesInPaintOrder = new ArrayList<Face>(this.world.getFaces());
        facesInPaintOrder = this.faceSorter.sort(facesInPaintOrder, eyePts);
        for (Face f : facesInPaintOrder) {
            Path2D p;
            boolean drawOutline = f.getOutline();
            double[] plane = f.calculateNormal(eyePts);
            double inprod = plane[0] * this.world.getSunX() + plane[1] * this.world.getSunY() + plane[2] * this.world.getSunZ();
            double shade = (inprod + 1.0) / 2.0;
            if (f instanceof DoubleSidedFace || Utils2D.area2(pts[f.getVertexIndex(0)], pts[f.getVertexIndex(1)], pts[f.getVertexIndex(2)]) > 0.0) {
                Color c = f.getColor();
                if (c != null) {
                    p = f.createPath(pts);
                    g2.setPaint(new Color((int)((double)c.getRed() * shade), (int)((double)c.getGreen() * shade), (int)((double)c.getBlue() * shade), c.getAlpha()));
                    if (this.elementHinting) {
                        this.beginElementGroup(f, g2);
                    }
                    g2.fill(p);
                    if (drawOutline) {
                        g2.draw(p);
                    }
                    if (this.elementHinting) {
                        this.endElementGroup(f, g2);
                    }
                }
                if (!(f instanceof ChartBox3D.ChartBoxFace) || !(this.plot instanceof CategoryPlot3D) && !(this.plot instanceof XYZPlot)) continue;
                Stroke savedStroke = g2.getStroke();
                ChartBox3D.ChartBoxFace cbf = (ChartBox3D.ChartBoxFace)f;
                this.drawGridlines(g2, cbf, pts);
                this.drawMarkers(g2, cbf, pts);
                g2.setStroke(savedStroke);
                continue;
            }
            if (!(f instanceof LabelFace)) continue;
            LabelFace lf = (LabelFace)f;
            p = lf.createPath(pts);
            Rectangle2D lb = p.getBounds2D();
            g2.setFont(lf.getFont());
            g2.setColor(lf.getBackgroundColor());
            Rectangle2D bb = TextUtils.calcAlignedStringBounds(lf.getLabel(), g2, (float)lb.getCenterX(), (float)lb.getCenterY(), TextAnchor.CENTER);
            g2.fill(bb);
            g2.setColor(lf.getTextColor());
            Rectangle2D r = TextUtils.drawAlignedString(lf.getLabel(), g2, (float)lb.getCenterX(), (float)lb.getCenterY(), TextAnchor.CENTER);
            lf.getOwner().setProperty("labelBounds", r);
        }
        RenderingInfo info = new RenderingInfo(facesInPaintOrder, pts, dx, dy);
        OnDrawHandler onDrawHandler = new OnDrawHandler(info, this.elementHinting);
        if (this.plot instanceof PiePlot3D) {
            this.drawPieLabels(g2, w, h, depth, info);
        }
        if (this.plot instanceof XYZPlot || this.plot instanceof CategoryPlot3D) {
            this.drawAxes(g2, chartBox, pts, info);
        }
        g2.setTransform(saved);
        if (this.legendBuilder != null && (legend = this.legendBuilder.createLegend(this.plot, this.legendAnchor, this.legendOrientation, this.style)) != null) {
            GridElement legend2 = new GridElement();
            legend2.setBackground(null);
            legend2.setElement(legend, (Comparable<?>)((Object)"R1"), (Comparable<?>)((Object)"C1"));
            TextElement te = new TextElement("Orson Charts (evaluation) (c) 2013, 2014, by Object Refinery Limited", this.style.getLegendFooterFont());
            te.setColor(this.style.getLegendFooterColor());
            te.setBackgroundColor(this.style.getLegendFooterBackgroundColor());
            te.setHorizontalAligment(HAlign.RIGHT);
            legend2.setElement(te, (Comparable<?>)((Object)"R2"), (Comparable<?>)((Object)"C1"));
            legend = legend2;
            Dimension2D legendSize = legend.preferredSize(g2, bounds);
            Rectangle2D legendArea = this.calculateDrawArea(legendSize, this.legendAnchor, bounds);
            legend.draw(g2, legendArea, onDrawHandler);
        }
        if (this.title != null) {
            Dimension2D titleSize = this.title.preferredSize(g2, bounds);
            Rectangle2D titleArea = this.calculateDrawArea(titleSize, this.titleAnchor, bounds);
            this.title.draw(g2, titleArea, onDrawHandler);
        }
        g2.setClip(savedClip);
        this.endElement(g2);
        return info;
    }

    private void beginElementGroup(Face face, Graphics2D g2) {
        Object3D owner = face.getOwner();
        ItemKey itemKey = (ItemKey)owner.getProperty("key");
        if (itemKey != null) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("ref", itemKey.toJSONString());
            g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
        }
    }

    private void endElementGroup(Face face, Graphics2D g2) {
        Object3D owner = face.getOwner();
        ItemKey itemKey = (ItemKey)owner.getProperty("key");
        if (itemKey != null) {
            g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, Boolean.TRUE);
        }
    }

    private List<TickData> fetchXTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getColumnAxis().generateTickDataForColumns(cp.getDataset());
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getXAxis().generateTickData(tickUnit);
        }
        return Collections.emptyList();
    }

    private List<TickData> fetchYTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getValueAxis().generateTickData(tickUnit);
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getYAxis().generateTickData(tickUnit);
        }
        return Collections.emptyList();
    }

    private List<TickData> fetchZTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getRowAxis().generateTickDataForRows(cp.getDataset());
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getZAxis().generateTickData(tickUnit);
        }
        return Collections.emptyList();
    }

    private List<MarkerData> fetchXMarkerData(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getColumnAxis().generateMarkerData();
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getXAxis().generateMarkerData();
        }
        return new ArrayList<MarkerData>(0);
    }

    private List<MarkerData> fetchYMarkerData(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getValueAxis().generateMarkerData();
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getYAxis().generateMarkerData();
        }
        return new ArrayList<MarkerData>(0);
    }

    private List<MarkerData> fetchZMarkerData(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getRowAxis().generateMarkerData();
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getZAxis().generateMarkerData();
        }
        return new ArrayList<MarkerData>(0);
    }

    private void drawGridlines(Graphics2D g2, ChartBox3D.ChartBoxFace face, Point2D[] pts) {
        Line2D.Double line;
        int i;
        if (this.isGridlinesVisibleForX(this.plot)) {
            g2.setPaint(this.fetchGridlinePaintX(this.plot));
            g2.setStroke(this.fetchGridlineStrokeX(this.plot));
            List<TickData> xA = face.getXTicksA();
            List<TickData> xB = face.getXTicksB();
            for (i = 0; i < xA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + xA.get(i).getVertexIndex()], pts[face.getOffset() + xB.get(i).getVertexIndex()]);
                g2.draw(line);
            }
        }
        if (this.isGridlinesVisibleForY(this.plot)) {
            g2.setPaint(this.fetchGridlinePaintY(this.plot));
            g2.setStroke(this.fetchGridlineStrokeY(this.plot));
            List<TickData> yA = face.getYTicksA();
            List<TickData> yB = face.getYTicksB();
            for (i = 0; i < yA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + yA.get(i).getVertexIndex()], pts[face.getOffset() + yB.get(i).getVertexIndex()]);
                g2.draw(line);
            }
        }
        if (this.isGridlinesVisibleForZ(this.plot)) {
            g2.setPaint(this.fetchGridlinePaintZ(this.plot));
            g2.setStroke(this.fetchGridlineStrokeZ(this.plot));
            List<TickData> zA = face.getZTicksA();
            List<TickData> zB = face.getZTicksB();
            for (i = 0; i < zA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + zA.get(i).getVertexIndex()], pts[face.getOffset() + zB.get(i).getVertexIndex()]);
                g2.draw(line);
            }
        }
    }

    private boolean isGridlinesVisibleForX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleX();
        }
        return false;
    }

    private boolean isGridlinesVisibleForY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleY();
        }
        return false;
    }

    private boolean isGridlinesVisibleForZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleZ();
        }
        return false;
    }

    private Paint fetchGridlinePaintX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintX();
        }
        return null;
    }

    private Paint fetchGridlinePaintY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintY();
        }
        return null;
    }

    private Paint fetchGridlinePaintZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintZ();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeX();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeY();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeZ();
        }
        return null;
    }

    private void drawPieLabels(Graphics2D g2, double w, double h, double depth, RenderingInfo info) {
        PiePlot3D p = (PiePlot3D)this.plot;
        World labelOverlay = new World();
        List<Object3D> objs = p.getLabelFaces(-w / 2.0, -h / 2.0, -depth / 2.0);
        for (Object3D obj : objs) {
            labelOverlay.add(obj);
        }
        Point2D[] ppts = labelOverlay.calculateProjectedPoints(this.viewPoint, this.projDist);
        for (int i = 0; i < p.getDataset().getItemCount() * 2; ++i) {
            Face f;
            if (p.getDataset().getValue(i / 2) == null || !(Utils2D.area2(ppts[(f = labelOverlay.getFaces().get(i)).getVertexIndex(0)], ppts[f.getVertexIndex(1)], ppts[f.getVertexIndex(2)]) > 0.0)) continue;
            Comparable<?> key = p.getDataset().getKey(i / 2);
            g2.setColor(p.getSectionLabelColorSource().getColor(key));
            g2.setFont(p.getSectionLabelFontSource().getFont(key));
            Point2D pt = Utils2D.centerPoint(ppts[f.getVertexIndex(0)], ppts[f.getVertexIndex(1)], ppts[f.getVertexIndex(2)], ppts[f.getVertexIndex(3)]);
            String label = p.getSectionLabelGenerator().generateLabel(p.getDataset(), key);
            String ref = "{\"type\": \"sectionLabel\", \"key\": \"" + key.toString() + "\"}";
            this.beginElementWithRef(g2, ref);
            Rectangle2D bounds = TextUtils.drawAlignedString(label, g2, (float)pt.getX(), (float)pt.getY(), TextAnchor.CENTER);
            this.endElement(g2);
            if (info == null) continue;
            RenderedElement pieLabelRE = new RenderedElement((Object)InteractiveElementType.SECTION_LABEL, bounds);
            pieLabelRE.setProperty("key", key);
            info.addOffsetElement(pieLabelRE);
        }
    }

    private void beginElementWithRef(Graphics2D g2, String ref) {
        this.beginElement(g2, null, ref);
    }

    private void beginElement(Graphics2D g2, String id, String ref) {
        if (this.elementHinting) {
            HashMap<String, String> m = new HashMap<String, String>();
            if (id != null) {
                m.put("id", id);
            }
            m.put("ref", ref);
            g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
        }
    }

    private void endElement(Graphics2D g2) {
        if (this.elementHinting) {
            g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, Boolean.TRUE);
        }
    }

    private double[] findAxisTickUnits(Graphics2D g2, double w, double h, double depth) {
        AbstractPlot3D pp;
        World tempWorld = new World();
        ChartBox3D chartBox = new ChartBox3D(w, h, depth, -w / 2.0, -h / 2.0, -depth / 2.0, Color.WHITE);
        tempWorld.add(chartBox.createObject3D());
        Point2D[] axisPts2D = tempWorld.calculateProjectedPoints(this.viewPoint, this.projDist);
        Point2D v0 = axisPts2D[0];
        Point2D v1 = axisPts2D[1];
        Point2D v2 = axisPts2D[2];
        Point2D v3 = axisPts2D[3];
        Point2D v4 = axisPts2D[4];
        Point2D v5 = axisPts2D[5];
        Point2D v6 = axisPts2D[6];
        Point2D v7 = axisPts2D[7];
        boolean a = chartBox.faceA().isFrontFacing(axisPts2D);
        boolean b = chartBox.faceB().isFrontFacing(axisPts2D);
        boolean c = chartBox.faceC().isFrontFacing(axisPts2D);
        boolean d = chartBox.faceD().isFrontFacing(axisPts2D);
        boolean e = chartBox.faceE().isFrontFacing(axisPts2D);
        boolean f = chartBox.faceF().isFrontFacing(axisPts2D);
        double xtick = 0.0;
        double ytick = 0.0;
        double ztick = 0.0;
        Axis3D xAxis = null;
        ValueAxis3D yAxis = null;
        Axis3D zAxis = null;
        if (this.plot instanceof XYZPlot) {
            pp = (XYZPlot)this.plot;
            xAxis = ((XYZPlot)pp).getXAxis();
            yAxis = ((XYZPlot)pp).getYAxis();
            zAxis = ((XYZPlot)pp).getZAxis();
        } else if (this.plot instanceof CategoryPlot3D) {
            pp = (CategoryPlot3D)this.plot;
            xAxis = ((CategoryPlot3D)pp).getColumnAxis();
            yAxis = ((CategoryPlot3D)pp).getValueAxis();
            zAxis = ((CategoryPlot3D)pp).getRowAxis();
        }
        if (xAxis != null && yAxis != null && zAxis != null) {
            double ce;
            double ab = this.count(a, b) == 1 ? v0.distance(v1) : 0.0;
            double bc = this.count(b, c) == 1 ? v3.distance(v2) : 0.0;
            double cd = this.count(c, d) == 1 ? v4.distance(v7) : 0.0;
            double da = this.count(d, a) == 1 ? v5.distance(v6) : 0.0;
            double be = this.count(b, e) == 1 ? v0.distance(v3) : 0.0;
            double bf = this.count(b, f) == 1 ? v1.distance(v2) : 0.0;
            double df = this.count(d, f) == 1 ? v6.distance(v7) : 0.0;
            double de = this.count(d, e) == 1 ? v5.distance(v4) : 0.0;
            double ae = this.count(a, e) == 1 ? v0.distance(v5) : 0.0;
            double af = this.count(a, f) == 1 ? v1.distance(v6) : 0.0;
            double cf = this.count(c, f) == 1 ? v2.distance(v7) : 0.0;
            double d2 = ce = this.count(c, e) == 1 ? v3.distance(v4) : 0.0;
            if (this.count(a, b) == 1 && this.longest(ab, bc, cd, da) && xAxis instanceof ValueAxis3D) {
                xtick = xAxis.selectTick(g2, v0, v1, v7);
            }
            if (this.count(b, c) == 1 && this.longest(bc, ab, cd, da) && xAxis instanceof ValueAxis3D) {
                xtick = ((ValueAxis3D)xAxis).selectTick(g2, v3, v2, v6);
            }
            if (this.count(c, d) == 1 && this.longest(cd, ab, bc, da) && xAxis instanceof ValueAxis3D) {
                xtick = ((ValueAxis3D)xAxis).selectTick(g2, v4, v7, v1);
            }
            if (this.count(d, a) == 1 && this.longest(da, ab, bc, cd) && xAxis instanceof ValueAxis3D) {
                xtick = ((ValueAxis3D)xAxis).selectTick(g2, v5, v6, v3);
            }
            if (this.count(b, e) == 1 && this.longest(be, bf, df, de)) {
                ytick = yAxis.selectTick(g2, v0, v3, v7);
            }
            if (this.count(b, f) == 1 && this.longest(bf, be, df, de)) {
                ytick = yAxis.selectTick(g2, v1, v2, v4);
            }
            if (this.count(d, f) == 1 && this.longest(df, be, bf, de)) {
                ytick = yAxis.selectTick(g2, v6, v7, v0);
            }
            if (this.count(d, e) == 1 && this.longest(de, be, bf, df)) {
                ytick = yAxis.selectTick(g2, v5, v4, v1);
            }
            if (this.count(a, e) == 1 && this.longest(ae, af, cf, ce) && zAxis instanceof ValueAxis3D) {
                ztick = zAxis.selectTick(g2, v0, v5, v2);
            }
            if (this.count(a, f) == 1 && this.longest(af, ae, cf, ce) && zAxis instanceof ValueAxis3D) {
                ztick = ((ValueAxis3D)zAxis).selectTick(g2, v1, v6, v3);
            }
            if (this.count(c, f) == 1 && this.longest(cf, ae, af, ce) && zAxis instanceof ValueAxis3D) {
                ztick = ((ValueAxis3D)zAxis).selectTick(g2, v2, v7, v5);
            }
            if (this.count(c, e) == 1 && this.longest(ce, ae, af, cf) && zAxis instanceof ValueAxis3D) {
                ztick = ((ValueAxis3D)zAxis).selectTick(g2, v3, v4, v6);
            }
        }
        return new double[]{xtick, ytick, ztick};
    }

    private void populateAnchorPoints(List<TickData> tickData, Point2D[] pts) {
        for (TickData t : tickData) {
            t.setAnchorPt(pts[t.getVertexIndex()]);
        }
    }

    private void drawAxes(Graphics2D g2, ChartBox3D chartBox, Point2D[] pts, RenderingInfo info) {
        AbstractPlot3D pp;
        Point2D v0 = pts[0];
        Point2D v1 = pts[1];
        Point2D v2 = pts[2];
        Point2D v3 = pts[3];
        Point2D v4 = pts[4];
        Point2D v5 = pts[5];
        Point2D v6 = pts[6];
        Point2D v7 = pts[7];
        boolean a = chartBox.faceA().isFrontFacing(pts);
        boolean b = chartBox.faceB().isFrontFacing(pts);
        boolean c = chartBox.faceC().isFrontFacing(pts);
        boolean d = chartBox.faceD().isFrontFacing(pts);
        boolean e = chartBox.faceE().isFrontFacing(pts);
        boolean f = chartBox.faceF().isFrontFacing(pts);
        Axis3D xAxis = null;
        ValueAxis3D yAxis = null;
        Axis3D zAxis = null;
        if (this.plot instanceof XYZPlot) {
            pp = (XYZPlot)this.plot;
            xAxis = ((XYZPlot)pp).getXAxis();
            yAxis = ((XYZPlot)pp).getYAxis();
            zAxis = ((XYZPlot)pp).getZAxis();
        } else if (this.plot instanceof CategoryPlot3D) {
            pp = (CategoryPlot3D)this.plot;
            xAxis = ((CategoryPlot3D)pp).getColumnAxis();
            yAxis = ((CategoryPlot3D)pp).getValueAxis();
            zAxis = ((CategoryPlot3D)pp).getRowAxis();
        }
        if (xAxis != null && yAxis != null && zAxis != null) {
            List<TickData> ticks;
            double ce;
            double ab = this.count(a, b) == 1 ? v0.distance(v1) : 0.0;
            double bc = this.count(b, c) == 1 ? v3.distance(v2) : 0.0;
            double cd = this.count(c, d) == 1 ? v4.distance(v7) : 0.0;
            double da = this.count(d, a) == 1 ? v5.distance(v6) : 0.0;
            double be = this.count(b, e) == 1 ? v0.distance(v3) : 0.0;
            double bf = this.count(b, f) == 1 ? v1.distance(v2) : 0.0;
            double df = this.count(d, f) == 1 ? v6.distance(v7) : 0.0;
            double de = this.count(d, e) == 1 ? v5.distance(v4) : 0.0;
            double ae = this.count(a, e) == 1 ? v0.distance(v5) : 0.0;
            double af = this.count(a, f) == 1 ? v1.distance(v6) : 0.0;
            double cf = this.count(c, f) == 1 ? v2.distance(v7) : 0.0;
            double d2 = ce = this.count(c, e) == 1 ? v3.distance(v4) : 0.0;
            if (this.count(a, b) == 1 && this.longest(ab, bc, cd, da)) {
                ticks = chartBox.faceA().getXTicksA();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v0, v1, v7, ticks, info, this.elementHinting);
            }
            if (this.count(b, c) == 1 && this.longest(bc, ab, cd, da)) {
                ticks = chartBox.faceB().getXTicksB();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v3, v2, v6, ticks, info, this.elementHinting);
            }
            if (this.count(c, d) == 1 && this.longest(cd, ab, bc, da)) {
                ticks = chartBox.faceC().getXTicksB();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v4, v7, v1, ticks, info, this.elementHinting);
            }
            if (this.count(d, a) == 1 && this.longest(da, ab, bc, cd)) {
                ticks = chartBox.faceA().getXTicksB();
                this.populateAnchorPoints(ticks, pts);
                xAxis.draw(g2, v5, v6, v3, ticks, info, this.elementHinting);
            }
            if (this.count(b, e) == 1 && this.longest(be, bf, df, de)) {
                ticks = chartBox.faceB().getYTicksA();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v0, v3, v7, ticks, info, this.elementHinting);
            }
            if (this.count(b, f) == 1 && this.longest(bf, be, df, de)) {
                ticks = chartBox.faceB().getYTicksB();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v1, v2, v4, ticks, info, this.elementHinting);
            }
            if (this.count(d, f) == 1 && this.longest(df, be, bf, de)) {
                ticks = chartBox.faceD().getYTicksA();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v6, v7, v0, ticks, info, this.elementHinting);
            }
            if (this.count(d, e) == 1 && this.longest(de, be, bf, df)) {
                ticks = chartBox.faceD().getYTicksB();
                this.populateAnchorPoints(ticks, pts);
                yAxis.draw(g2, v5, v4, v1, ticks, info, this.elementHinting);
            }
            if (this.count(a, e) == 1 && this.longest(ae, af, cf, ce)) {
                ticks = chartBox.faceA().getZTicksA();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v0, v5, v2, ticks, info, this.elementHinting);
            }
            if (this.count(a, f) == 1 && this.longest(af, ae, cf, ce)) {
                ticks = chartBox.faceA().getZTicksB();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v1, v6, v3, ticks, info, this.elementHinting);
            }
            if (this.count(c, f) == 1 && this.longest(cf, ae, af, ce)) {
                ticks = chartBox.faceC().getZTicksB();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v2, v7, v5, ticks, info, this.elementHinting);
            }
            if (this.count(c, e) == 1 && this.longest(ce, ae, af, cf)) {
                ticks = chartBox.faceC().getZTicksA();
                this.populateAnchorPoints(ticks, pts);
                zAxis.draw(g2, v3, v4, v6, ticks, info, this.elementHinting);
            }
        }
    }

    private void drawMarkers(Graphics2D g2, ChartBox3D.ChartBoxFace face, Point2D[] pts) {
        List<MarkerData> xmarkers = face.getXMarkers();
        for (MarkerData markerData : xmarkers) {
            markerData.updateProjection(pts);
            Marker marker = this.fetchXMarker(this.plot, markerData.getMarkerKey());
            this.beginElementWithRef(g2, "{\"type\": \"xMarker\", \"key\": \"" + markerData.getMarkerKey() + "\"}");
            marker.draw(g2, markerData, true);
            this.endElement(g2);
        }
        List<MarkerData> ymarkers = face.getYMarkers();
        for (MarkerData m : ymarkers) {
            m.updateProjection(pts);
            Marker marker = this.fetchYMarker(this.plot, m.getMarkerKey());
            this.beginElementWithRef(g2, "{\"type\": \"yMarker\", \"key\": \"" + m.getMarkerKey() + "\"}");
            marker.draw(g2, m, false);
            this.endElement(g2);
        }
        List<MarkerData> list = face.getZMarkers();
        for (MarkerData m : list) {
            m.updateProjection(pts);
            this.beginElementWithRef(g2, "{\"type\": \"zMarker\", \"key\": \"" + m.getMarkerKey() + "\"}");
            Marker marker = this.fetchZMarker(this.plot, m.getMarkerKey());
            marker.draw(g2, m, false);
            this.endElement(g2);
        }
    }

    private Marker fetchXMarker(Plot3D plot, String key) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getColumnAxis().getMarker(key);
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getXAxis().getMarker(key);
        }
        return null;
    }

    private Marker fetchYMarker(Plot3D plot, String key) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getValueAxis().getMarker(key);
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getYAxis().getMarker(key);
        }
        return null;
    }

    private Marker fetchZMarker(Plot3D plot, String key) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getRowAxis().getMarker(key);
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getZAxis().getMarker(key);
        }
        return null;
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        this.plot.receive(visitor);
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Chart3D)) {
            return false;
        }
        Chart3D that = (Chart3D)obj;
        if (!ObjectUtils.equals(this.background, that.background)) {
            return false;
        }
        if (!ObjectUtils.equals(this.title, that.title)) {
            return false;
        }
        if (!this.titleAnchor.equals(that.titleAnchor)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.chartBoxColor, that.chartBoxColor)) {
            return false;
        }
        if (!ObjectUtils.equals(this.legendBuilder, that.legendBuilder)) {
            return false;
        }
        if (!this.legendAnchor.equals(that.legendAnchor)) {
            return false;
        }
        if (this.legendOrientation != that.legendOrientation) {
            return false;
        }
        if (!this.renderingHints.equals(that.renderingHints)) {
            return false;
        }
        return this.projDist == that.projDist;
    }

    private Rectangle2D calculateDrawArea(Dimension2D dim, Anchor2D anchor, Rectangle2D bounds) {
        double y;
        double x;
        ArgChecks.nullNotPermitted(dim, "dim");
        ArgChecks.nullNotPermitted(anchor, "anchor");
        ArgChecks.nullNotPermitted(bounds, "bounds");
        double w = Math.min(dim.getWidth(), bounds.getWidth());
        double h = Math.min(dim.getHeight(), bounds.getHeight());
        if (anchor.getRefPt().equals((Object)RefPt2D.CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.CENTER_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.CENTER_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else {
            x = 0.0;
            y = 0.0;
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    private boolean longest(double x, double a, double b, double c) {
        return x >= a && x >= b && x >= c;
    }

    private int count(boolean a, boolean b) {
        int result = 0;
        if (a) {
            ++result;
        }
        if (b) {
            ++result;
        }
        return result;
    }

    @Override
    public void plotChanged(Plot3DChangeEvent event) {
        if (event.requiresWorldUpdate()) {
            this.world = null;
        }
        this.notifyListeners(new Chart3DChangeEvent(event, this));
    }

    @Override
    public void styleChanged(ChartStyleChangeEvent event) {
        ChartStyler styler = new ChartStyler(event.getChartStyle());
        this.receive(styler);
        this.notifyListeners(new Chart3DChangeEvent(event, this));
    }

    public void addChangeListener(Chart3DChangeListener listener) {
        this.listenerList.add(Chart3DChangeListener.class, listener);
    }

    public void removeChangeListener(Chart3DChangeListener listener) {
        this.listenerList.remove(Chart3DChangeListener.class, listener);
    }

    public void notifyListeners(Chart3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Chart3DChangeListener.class) continue;
            ((Chart3DChangeListener)listeners[i + 1]).chartChanged(event);
        }
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.world = null;
            this.fireChangeEvent();
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new Chart3DChangeEvent(this, this));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.plot.addChangeListener(this);
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static String renderedElementToString(RenderedElement element) {
        Object type = element.getProperty("type");
        if (InteractiveElementType.SECTION_LABEL.equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Section label with key '");
            Object key = element.getProperty("key");
            sb.append(key.toString());
            sb.append("'");
            return sb.toString();
        }
        if (InteractiveElementType.LEGEND_ITEM.equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Legend item with section key '");
            Object key = element.getProperty(SERIES_KEY);
            sb.append(key);
            sb.append("'");
            return sb.toString();
        }
        if (InteractiveElementType.AXIS_LABEL.equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Axis label with the label '");
            sb.append(element.getProperty("label"));
            sb.append("'");
            return sb.toString();
        }
        if (InteractiveElementType.CATEGORY_AXIS_TICK_LABEL.equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Axis tick label with the label '");
            sb.append(element.getProperty("label"));
            sb.append("'");
            return sb.toString();
        }
        if (InteractiveElementType.VALUE_AXIS_TICK_LABEL.equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Axis tick label with the value '");
            sb.append(element.getProperty("value"));
            sb.append("'");
            return sb.toString();
        }
        if ("obj3d".equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("An object in the 3D model");
            ItemKey itemKey = (ItemKey)element.getProperty("key");
            if (itemKey != null) {
                sb.append(" representing the data item [");
                sb.append(itemKey.toString());
                sb.append("]");
            }
            return sb.toString();
        }
        return element.toString();
    }
}

