/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.legend;

import com.orsoncharts.interaction.InteractiveElementType;
import com.orsoncharts.legend.LegendBuilder;
import com.orsoncharts.legend.LegendItemInfo;
import com.orsoncharts.plot.Plot3D;
import com.orsoncharts.style.ChartStyle;
import com.orsoncharts.table.AbstractTableElement;
import com.orsoncharts.table.FlowElement;
import com.orsoncharts.table.GridElement;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.ShapeElement;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TextElement;
import com.orsoncharts.table.VAlign;
import com.orsoncharts.table.VerticalFlowElement;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.Orientation;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.io.Serializable;
import java.util.List;

public final class StandardLegendBuilder
implements LegendBuilder,
Serializable {
    private String header;
    private HAlign headerAlignment;
    private String footer;
    private HAlign footerAlignment;
    private HAlign rowAlignment;
    private VAlign columnAlignment;

    public StandardLegendBuilder() {
        this(null, null);
    }

    public StandardLegendBuilder(String header, String footer) {
        this.header = header;
        this.headerAlignment = HAlign.LEFT;
        this.footer = footer;
        this.footerAlignment = HAlign.RIGHT;
        this.rowAlignment = null;
        this.columnAlignment = null;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public HAlign getHeaderAlignment() {
        return this.headerAlignment;
    }

    public void setHeaderAlignment(HAlign align) {
        ArgChecks.nullNotPermitted((Object)align, "align");
        this.headerAlignment = align;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public HAlign getFooterAlignment() {
        return this.footerAlignment;
    }

    public void setFooterAlignment(HAlign align) {
        ArgChecks.nullNotPermitted((Object)align, "align");
        this.footerAlignment = align;
    }

    public HAlign getRowAlignment() {
        return this.rowAlignment;
    }

    public void setRowAlignment(HAlign alignment) {
        this.rowAlignment = alignment;
    }

    public VAlign getColumnAlignment() {
        return this.columnAlignment;
    }

    public void setColumnAlignment(VAlign alignment) {
        this.columnAlignment = alignment;
    }

    @Override
    public TableElement createLegend(Plot3D plot, Anchor2D anchor, Orientation orientation, ChartStyle style) {
        TableElement legend = this.createSimpleLegend(plot.getLegendInfo(), anchor, orientation, style);
        if (this.header != null || this.footer != null) {
            GridElement compositeLegend = new GridElement();
            compositeLegend.setBackground(null);
            if (this.header != null) {
                TextElement he = new TextElement(this.header, style.getLegendHeaderFont());
                he.setHorizontalAligment(this.headerAlignment);
                he.setBackgroundColor(style.getLegendHeaderBackgroundColor());
                compositeLegend.setElement(he, (Comparable<?>)((Object)"R0"), (Comparable<?>)((Object)"C1"));
            }
            compositeLegend.setElement(legend, (Comparable<?>)((Object)"R1"), (Comparable<?>)((Object)"C1"));
            if (this.footer != null) {
                TextElement fe = new TextElement(this.footer, style.getLegendFooterFont());
                fe.setHorizontalAligment(this.footerAlignment);
                fe.setBackgroundColor(style.getLegendFooterBackgroundColor());
                compositeLegend.setElement(fe, (Comparable<?>)((Object)"R2"), (Comparable<?>)((Object)"C1"));
            }
            return compositeLegend;
        }
        return legend;
    }

    private TableElement createSimpleLegend(List<LegendItemInfo> items, Anchor2D anchor, Orientation orientation, ChartStyle style) {
        AbstractTableElement legend;
        ArgChecks.nullNotPermitted(items, "items");
        ArgChecks.nullNotPermitted((Object)orientation, "orientation");
        if (orientation == Orientation.HORIZONTAL) {
            FlowElement fe = new FlowElement(this.horizontalAlignment(anchor), 2);
            fe.setRefPoint(anchor.getRefPt());
            legend = fe;
        } else {
            VerticalFlowElement vfe = new VerticalFlowElement(this.verticalAlignment(anchor), 2);
            vfe.setRefPoint(anchor.getRefPt());
            legend = vfe;
        }
        for (LegendItemInfo item : items) {
            Shape shape = item.getShape();
            if (shape == null) {
                shape = style.getLegendItemShape();
            }
            TableElement legendItem = this.createLegendItem(item.getLabel(), style.getLegendItemFont(), style.getLegendItemColor(), shape, item.getColor(), style.getLegendItemBackgroundColor());
            legendItem.setProperty("class", (Object)InteractiveElementType.LEGEND_ITEM);
            legendItem.setProperty("series_key", item.getSeriesKey());
            legend.addElement(legendItem);
        }
        return legend;
    }

    private HAlign horizontalAlignment(Anchor2D anchor) {
        if (this.rowAlignment != null) {
            return this.rowAlignment;
        }
        if (anchor.getRefPt().isLeft()) {
            return HAlign.LEFT;
        }
        if (anchor.getRefPt().isRight()) {
            return HAlign.RIGHT;
        }
        return HAlign.CENTER;
    }

    private VAlign verticalAlignment(Anchor2D anchor) {
        if (this.columnAlignment != null) {
            return this.columnAlignment;
        }
        if (anchor.getRefPt().isTop()) {
            return VAlign.TOP;
        }
        if (anchor.getRefPt().isBottom()) {
            return VAlign.BOTTOM;
        }
        return VAlign.MIDDLE;
    }

    private TableElement createLegendItem(String text, Font font, Color textColor, Shape shape, Color shapeColor, Color background) {
        ShapeElement se = new ShapeElement(shape, shapeColor);
        se.setBackgroundColor(background);
        TextElement te = new TextElement(text, font);
        te.setColor(textColor);
        te.setBackgroundColor(background);
        GridElement ge = new GridElement();
        ge.setElement(se, (Comparable<?>)((Object)"R1"), (Comparable<?>)((Object)"C1"));
        ge.setElement(te, (Comparable<?>)((Object)"R1"), (Comparable<?>)((Object)"C2"));
        return ge;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardLegendBuilder)) {
            return false;
        }
        StandardLegendBuilder that = (StandardLegendBuilder)obj;
        if (!ObjectUtils.equals(this.header, that.header)) {
            return false;
        }
        if (this.headerAlignment != that.headerAlignment) {
            return false;
        }
        if (!ObjectUtils.equals(this.footer, that.footer)) {
            return false;
        }
        return this.footerAlignment == that.footerAlignment;
    }
}

