/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.table;

import com.orsoncharts.table.RectanglePainter;
import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public final class GradientRectanglePainter
implements RectanglePainter,
Serializable {
    private final Color color1;
    private final Anchor2D anchor1;
    private final Color color2;
    private final Anchor2D anchor2;

    public GradientRectanglePainter(Color color1, Anchor2D anchor1, Color color2, Anchor2D anchor2) {
        ArgChecks.nullNotPermitted(color1, "color1");
        ArgChecks.nullNotPermitted(anchor1, "anchor1");
        ArgChecks.nullNotPermitted(color2, "color2");
        ArgChecks.nullNotPermitted(anchor2, "anchor2");
        this.color1 = color1;
        this.anchor1 = anchor1;
        this.color2 = color2;
        this.anchor2 = anchor2;
    }

    public Color getColor1() {
        return this.color1;
    }

    public Anchor2D getAnchor1() {
        return this.anchor1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public Anchor2D getAnchor2() {
        return this.anchor2;
    }

    private GradientPaint createTransformedGradient(Rectangle2D area) {
        Point2D pt1 = this.anchor1.getAnchorPoint(area);
        Point2D pt2 = this.anchor2.getAnchorPoint(area);
        return new GradientPaint(pt1, this.color1, pt2, this.color2);
    }

    @Override
    public void fill(Graphics2D g2, Rectangle2D area) {
        Paint saved = g2.getPaint();
        g2.setPaint(this.createTransformedGradient(area));
        g2.fill(area);
        g2.setPaint(saved);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GradientRectanglePainter)) {
            return false;
        }
        GradientRectanglePainter that = (GradientRectanglePainter)obj;
        if (!this.color1.equals(that.color1)) {
            return false;
        }
        if (!this.anchor1.equals(that.anchor1)) {
            return false;
        }
        if (!this.color2.equals(that.color2)) {
            return false;
        }
        return this.anchor2.equals(that.anchor2);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + ObjectUtils.hashCode(this.color1);
        hash = 67 * hash + ObjectUtils.hashCode(this.anchor1);
        hash = 67 * hash + ObjectUtils.hashCode(this.color2);
        hash = 67 * hash + ObjectUtils.hashCode(this.anchor2);
        return hash;
    }
}

