/*
 * Decompiled with CFR 0.152.
 */
package kline.emulator;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import kline.emulator.Event;
import kline.emulator.KlineEmulator;
import kline.emulator.Surface;

public class Gui
extends JFrame {
    Surface surface;
    JSlider slider;
    static Event.EventAction updateSlider;
    private final int SLIDER_MAX = 111;

    public Gui(ChangeListener listner) {
        this.initUI(listner);
    }

    Event.EventAction getSliderEventListner() {
        return updateSlider;
    }

    private void initUI(ChangeListener listner) {
        this.setTitle("Kline simulator v1.0");
        boolean[] initSprinklerStatus = new boolean[KlineEmulator.MAX_SPRINKLERS];
        initSprinklerStatus = new boolean[]{false, false, false, false, false, false, false, false, false, false};
        FlowLayout layout = new FlowLayout();
        this.setLayout(layout);
        this.surface = new Surface(KlineEmulator.MAX_SPRINKLERS, initSprinklerStatus, "");
        this.slider = this.createSlider();
        this.slider.addChangeListener(listner);
        this.add(this.slider);
        this.add(this.surface);
        this.pack();
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        updateSlider = new Event.EventAction(){

            @Override
            public void action(int value) {
                int MULT_FACTOR = 7;
                Gui.this.slider.setValue(Math.min(111, 111 * value * MULT_FACTOR / 100));
            }
        };
    }

    private JSlider createSlider() {
        this.slider = new JSlider(1, 0, 111, 70);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(5);
        this.slider.setBounds(0, 20, 100, 100);
        this.slider.setPreferredSize(new Dimension(80, 200));
        this.slider.setPaintLabels(true);
        return this.slider;
    }

    public void updateUI(boolean[] sprinklerStatus, String linePressure) {
        this.remove(this.surface);
        this.surface = new Surface(KlineEmulator.MAX_SPRINKLERS, sprinklerStatus, linePressure);
        this.add(this.surface);
        this.pack();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

