/*
 * Decompiled with CFR 0.152.
 */
package kline.emulator;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jssc.SerialPortException;
import kline.emulator.Event;
import kline.emulator.Gui;
import kline.emulator.PumpLine;
import kline.emulator.SerialConnect;
import kline.emulator.SerialPortSelectorGui;
import kline.emulator.SprinklerController;

public class KlineEmulator {
    static GUI_MODE mode;
    static int MAX_SPRINKLERS;
    static int PRESSURE_CONSUMED_PER_SPRINKLER;
    static SprinklerController[] controllers;
    static PumpLine pumpLine;
    static PressureChangeListner pumpChangeListner;
    static SerialConnect serial;

    private static void setMode(GUI_MODE mode) {
        KlineEmulator.mode = mode;
    }

    private static GUI_MODE getMode() {
        return mode;
    }

    private static void startControllers(PumpLine pumpLine) {
        for (int i = 0; i < MAX_SPRINKLERS; ++i) {
            KlineEmulator.controllers[i] = new SprinklerController(pumpLine);
            controllers[i].setId(i);
            new Thread(controllers[i]).start();
        }
    }

    public static void main(String[] args) throws InterruptedException, IOException, SerialConnect.SerialPortNotFoundException {
        KlineEmulator.setMode(GUI_MODE.SERIAL_CONTROLLER);
        boolean[] sprinklerStatus = new boolean[MAX_SPRINKLERS];
        pumpLine = PumpLine.getInstance();
        double linePressureAvg = pumpLine.getLinePressure();
        int runs = 0;
        SerialPortSelectorGui serialSelectorGui = new SerialPortSelectorGui();
        serial = new SerialConnect(serialSelectorGui);
        Gui gui = new Gui(pumpChangeListner);
        if (KlineEmulator.getMode() == GUI_MODE.SERIAL_CONTROLLER) {
            Event.EventAction sliderUpdateListner = gui.getSliderEventListner();
            serial.startSerialThread(sliderUpdateListner);
        }
        KlineEmulator.startControllers(pumpLine);
        gui.setVisible(true);
        while (true) {
            ++runs;
            String sprinklerStatusString = "";
            int sprinklerStatusInt = 0;
            for (int i = 0; i < MAX_SPRINKLERS; ++i) {
                System.out.print(controllers[i].getOnCount() + ", ");
                sprinklerStatus[i] = controllers[i].isOn();
                if (controllers[i].isOn()) {
                    sprinklerStatusString = sprinklerStatusString + '1';
                    sprinklerStatusInt = sprinklerStatusInt << 1 | 1;
                    continue;
                }
                sprinklerStatusString = sprinklerStatusString + '0';
                sprinklerStatusInt <<= 1;
            }
            linePressureAvg = (linePressureAvg * (double)(runs - 1) + pumpLine.getLinePressure()) / (double)runs;
            System.out.println("LINE Pressure Avg : " + linePressureAvg);
            Thread.sleep(500L);
            System.err.println("\n=============================\n");
            gui.updateUI(sprinklerStatus, String.format("Avg: %.2f", linePressureAvg));
            if (KlineEmulator.getMode() != GUI_MODE.SERIAL_CONTROLLER) continue;
            try {
                serial.sendData(sprinklerStatusInt);
                continue;
            }
            catch (SerialPortException ex) {
                Logger.getLogger(KlineEmulator.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    static {
        MAX_SPRINKLERS = 8;
        PRESSURE_CONSUMED_PER_SPRINKLER = 10;
        controllers = new SprinklerController[MAX_SPRINKLERS];
        pumpChangeListner = new PressureChangeListner();
    }

    static class PressureChangeListner
    implements ChangeListener {
        PressureChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            JSlider slider = (JSlider)evt.getSource();
            if (!slider.getValueIsAdjusting()) {
                int value = slider.getValue();
                try {
                    pumpLine.setMaxAvailableLinePressure(value);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(KlineEmulator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    static enum GUI_MODE {
        SERIAL_CONTROLLER,
        GUI_CONTROLLER;

    }
}

