/*
 * Decompiled with CFR 0.152.
 */
package kline.emulator;

import java.util.concurrent.Semaphore;

public class PumpLine {
    public static double MAX_LINE_PRESSURE = 100.0;
    public double maxAvailableLinePressure = 70.0;
    Semaphore globalLock = new Semaphore(1);
    private static PumpLine pumpLine = null;
    private double linePressure = this.maxAvailableLinePressure;
    private int timeTick;

    public static PumpLine getInstance() {
        if (pumpLine == null) {
            pumpLine = new PumpLine();
        }
        return pumpLine;
    }

    public void acquireGlobalLock() throws InterruptedException {
        this.globalLock.acquire();
    }

    public void releaseGlobalLock() {
        this.globalLock.release();
    }

    public void setMaxAvailableLinePressure(double newLinePressure) throws InterruptedException {
        this.acquireGlobalLock();
        double lastLinePressure = this.maxAvailableLinePressure;
        this.linePressure += newLinePressure - lastLinePressure;
        this.maxAvailableLinePressure = newLinePressure;
        this.releaseGlobalLock();
    }

    public void setLinePressure(double pressure) throws InterruptedException {
        this.linePressure = pressure;
    }

    public double reduceLinePressureByVal(double val) throws InterruptedException {
        this.linePressure -= val;
        if (this.linePressure < 0.0) {
            this.linePressure = 0.0;
        }
        return this.linePressure;
    }

    public double increaseLinePressureByVal(double val) throws InterruptedException {
        this.linePressure += val;
        if (this.linePressure > this.maxAvailableLinePressure) {
            this.linePressure = this.maxAvailableLinePressure;
        }
        return this.linePressure;
    }

    public double getLinePressure() throws InterruptedException {
        double ret = this.linePressure;
        return ret;
    }
}

