/*
 * Decompiled with CFR 0.152.
 */
package kline.emulator;

import java.util.logging.Level;
import java.util.logging.Logger;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import kline.emulator.Event;
import kline.emulator.SerialPortSelectorGui;

public class SerialConnect {
    static SerialPort serialPort;
    Event serialDataToBeReadEvent = new Event();
    static String buffer;

    public void sendData(String data) throws SerialPortException {
        serialPort.writeString(data);
    }

    public void sendData(int data) throws SerialPortException {
        serialPort.writeInt(data);
    }

    public SerialConnect(SerialPortSelectorGui selectorGui) throws SerialPortNotFoundException {
        System.out.println("Init SerialConn");
        String[] portNames = SerialPortList.getPortNames();
        String serialPortArduino = "";
        String guiSelectedSerialPort = selectorGui.selectFromLabels(portNames);
        for (String portName : portNames) {
            if (portName.contains("ACM")) {
                serialPortArduino = portName;
                break;
            }
            if (!portName.contains(guiSelectedSerialPort)) continue;
            serialPortArduino = portName;
            System.out.println("Found Serial port " + portName);
            break;
        }
        if (serialPortArduino.isEmpty()) {
            throw new SerialPortNotFoundException("Serial Port not found");
        }
        serialPort = new SerialPort(serialPortArduino);
        try {
            serialPort.openPort();
            serialPort.setParams(57600, 8, 1, 0);
        }
        catch (SerialPortException ex) {
            new Exception().printStackTrace();
            System.out.println("Exception at constructor");
            System.out.println((Object)ex);
        }
    }

    public void startSerialThread(Event.EventAction listner) {
        this.serialDataToBeReadEvent.addListner(listner);
        readSerialStream serialListner = new readSerialStream();
        serialListner.start();
    }

    public void getSliderPositionFromSerial() throws SerialPortException {
        byte[] bytes;
        String str = serialPort.readString(4);
        for (byte b : bytes = str.getBytes()) {
            if (b != 10 && b != 13) {
                buffer = buffer.concat(String.valueOf((char)b));
            }
            if (b != 10) continue;
            System.out.println("####Slider status: " + buffer);
            this.serialDataToBeReadEvent.fireEvent(Integer.parseInt(buffer.trim()));
            buffer = " ";
        }
    }

    static {
        buffer = "0";
    }

    public class readSerialStream
    extends Thread {
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        SerialConnect.this.getSliderPositionFromSerial();
                    }
                }
                catch (SerialPortException ex) {
                    Logger.getLogger(SerialConnect.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        }
    }

    public class SerialPortNotFoundException
    extends Exception {
        public SerialPortNotFoundException(String message) {
            super(message);
        }
    }
}

