/*
 * Decompiled with CFR 0.152.
 */
package kline.emulator;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import kline.emulator.KlineEmulator;
import kline.emulator.PumpLine;

public class SprinklerController
implements Runnable {
    PumpLine pumpLine;
    static int MAX_TIME_SINCE_LAST_PEAK = 100;
    public static int LINE_PRESSURE_PEAK_THRESHOLD = 50;
    public static int MIN_PRESSURE_TO_START_ONE_SPRINKLER = 10;
    public double LAST_ON_TIME_WEIGHTAGE = 9.75;
    public int sprinklerId;
    double MAX_TIME_DURATION = 10.0;
    int SPRINKLER_ON_TIME = 2700;
    double timeSinceLastOn;
    double timeSinceLastPeak;
    int onCount = 0;
    SprinklerState sprinklerStatus;

    public SprinklerController(PumpLine pumpLine) {
        this.pumpLine = pumpLine;
    }

    @Override
    public void run() {
        while (true) {
            boolean controllerWasOn = this.isOn();
            try {
                this.runSprinklerControlLogic();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SprinklerController.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                Thread.sleep(this.SPRINKLER_ON_TIME);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SprinklerController.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    public void adjustLinePressure(boolean controllerWasOn) {
        if (!controllerWasOn && this.isOn()) {
            try {
                this.pumpLine.reduceLinePressureByVal(KlineEmulator.PRESSURE_CONSUMED_PER_SPRINKLER);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SprinklerController.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (controllerWasOn && !this.isOn()) {
            try {
                this.pumpLine.increaseLinePressureByVal(KlineEmulator.PRESSURE_CONSUMED_PER_SPRINKLER);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SprinklerController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setId(int id) {
        this.sprinklerId = id;
    }

    public int getOnCount() {
        return this.onCount;
    }

    int turnOn() {
        ++this.onCount;
        this.sprinklerStatus = SprinklerState.ON;
        return 0;
    }

    int turnOff() {
        this.sprinklerStatus = SprinklerState.OFF;
        return 0;
    }

    public boolean isOn() {
        return this.sprinklerStatus == SprinklerState.ON;
    }

    int canTurnOn() throws InterruptedException {
        double dice;
        Random rand = new Random(System.currentTimeMillis());
        double onPropablityBasedOnTime = this.timeSinceLastOn / this.MAX_TIME_DURATION;
        double onPropablityBasedOnPressure = this.pumpLine.getLinePressure() / PumpLine.MAX_LINE_PRESSURE;
        double onPropablityBasedOnLastPeak = 1.0 - this.timeSinceLastPeak / (double)MAX_TIME_SINCE_LAST_PEAK;
        if (rand.nextDouble() < onPropablityBasedOnTime) {
            boolean turnOnBasedOnTime = true;
        } else {
            boolean turnOnBasedOnTime = false;
        }
        if (rand.nextDouble() < onPropablityBasedOnPressure) {
            boolean turnOnBasedOnPressure = true;
        } else {
            boolean turnOnBasedOnPressure = false;
        }
        double netPropablity = 0.0;
        if (this.pumpLine.getLinePressure() <= (double)MIN_PRESSURE_TO_START_ONE_SPRINKLER) {
            netPropablity = onPropablityBasedOnTime * this.LAST_ON_TIME_WEIGHTAGE;
            if (netPropablity > 1.0) {
                netPropablity = 1.0;
            }
        } else {
            netPropablity = 1.0;
        }
        if ((dice = rand.nextDouble()) < netPropablity && this.pumpLine.getLinePressure() >= (double)MIN_PRESSURE_TO_START_ONE_SPRINKLER) {
            return 1;
        }
        return 0;
    }

    void runSprinklerControlLogic() throws InterruptedException {
        boolean currSprinklerState = this.isOn();
        this.pumpLine.acquireGlobalLock();
        if (this.canTurnOn() == 1) {
            this.timeSinceLastOn = 0.0;
            this.turnOn();
        } else {
            this.turnOff();
        }
        this.adjustLinePressure(currSprinklerState);
        if (this.pumpLine.getLinePressure() > (double)LINE_PRESSURE_PEAK_THRESHOLD) {
            this.timeSinceLastPeak = 0.0;
        }
        this.updateTimers();
        this.pumpLine.releaseGlobalLock();
    }

    void updateTimers() {
        this.timeSinceLastOn += 1.0;
        this.timeSinceLastPeak += 1.0;
        if (this.timeSinceLastOn >= this.MAX_TIME_DURATION) {
            this.timeSinceLastOn = this.MAX_TIME_DURATION;
        }
        if (this.timeSinceLastPeak >= (double)MAX_TIME_SINCE_LAST_PEAK) {
            this.timeSinceLastPeak = MAX_TIME_SINCE_LAST_PEAK;
        }
    }

    public static enum SprinklerState {
        ON,
        OFF;

    }
}

