/*
 * Decompiled with CFR 0.152.
 */
package kline.emulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class Surface
extends JPanel {
    private Image pipeline;
    private Image spray;
    private Image sprinkler;
    int maxSprinkers = 0;
    int[] sprinklerXRelativeOffsets = new int[10];
    int[] sprinklerYRelativeOffsets = new int[10];
    boolean[] sprinkerStatus;
    String linePressure;
    int xOffset = -20;
    int yOffset = -20;

    public Surface(int maxSprinklers, boolean[] sprinkerStatus, String linePressure) {
        this.loadImage();
        this.setSurfaceSize();
        this.maxSprinkers = maxSprinklers;
        this.sprinklerXRelativeOffsets = new int[]{145, 255, 385, 510, 625, 795, 920, 1035, 1170, 1280};
        this.sprinklerYRelativeOffsets = new int[]{-1, -1, -3, 0, 0, 1, 1, -4, 2, 2};
        this.sprinkerStatus = sprinkerStatus;
        this.linePressure = linePressure;
    }

    private void loadImage() {
        URL pipelineUrl = this.getClass().getResource("img/pipeline.jpg");
        URL sprinklerUrl = this.getClass().getResource("img/sprinkler.png");
        URL sprayUrl = this.getClass().getResource("img/spray_small.png");
        this.pipeline = new ImageIcon(pipelineUrl).getImage();
        this.sprinkler = new ImageIcon(sprinklerUrl).getImage();
        this.spray = new ImageIcon(sprayUrl).getImage();
    }

    private void setSurfaceSize() {
        Dimension d = new Dimension();
        d.width = 40 + this.pipeline.getWidth(null);
        d.height = 50 + this.pipeline.getHeight(null);
        this.setPreferredSize(d);
    }

    public void doDrawing(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(this.pipeline, this.xOffset + 50, this.yOffset + 50, null);
        for (int sprinklerCount = 0; sprinklerCount < this.maxSprinkers; ++sprinklerCount) {
            if (this.sprinkerStatus[sprinklerCount]) {
                g2d.drawImage(this.spray, this.xOffset + this.sprinklerXRelativeOffsets[sprinklerCount], this.yOffset + 89 + this.sprinklerYRelativeOffsets[sprinklerCount], null);
            }
            g2d.drawImage(this.sprinkler, this.xOffset + this.sprinklerXRelativeOffsets[sprinklerCount] + 35, this.yOffset + 192 + this.sprinklerYRelativeOffsets[sprinklerCount], null);
        }
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.setFont(new Font("Verdana", 1, 15));
        g2d.drawString(this.linePressure, this.xOffset + 60, this.yOffset + 215);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.doDrawing(g);
    }
}

